##################################################################################
#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on Noam Rathaus script
#
#  Ref: Ben Drysdale <ben@150bpm.co.uk>
#
#  Updated: 05/07/2009
#  Antu Sanadi <santu@secpod.com>
#
#
#
#  This script is released under the GNU GPL v2
#
#################################################################################

if(description)
{
  script_id(15480);
  script_bugtraq_id(9497);
  script_version("$Revision: 4564 $");
  name = "Xoops viewtopic.php Cross Site Scripting Vulnerability";
  script_name(name);

  desc = "
  Synopsis :

  The remote web server contains a PHP script that is prone to cross-
  site scripting attacks.

  Description :

  The weblinks module of XOOPS contains a file named 'viewtopic.php' in
  the '/modules/newbb' directory.  The code of the module insufficently
  filters out user provided data.  The URL parameter used by
  'viewtopic.php' can be used to insert malicious HTML and/or JavaScript
  in to the web page.

  See also :

  http://www.securitytracker.com/alerts/2004/Jan/1008849.html

  Solution :
  Unknown at this time.

  Risk factor :

  Low / CVSS Base Score : 2
  (AV:R/AC:L/Au:NR/C:P/A:N/I:N/B:N)";

  script_description(desc);
  summary = "Detect Xoops viewtopic.php XSS";
  script_summary(summary);
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  family = "Web application abuses";
  script_family(family);
  script_dependencie("cross_site_scripting.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");

xoopsPort = get_http_port(default:80);

if(!get_port_state(xoopsport)){
  exit(0);
}

foreach path (make_list("/", "/xoops/htdocs", "/xoops/htdocs/install", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:xoopsPort);
  rcvRes = http_send_recv(port:xoopsPort, data:sndReq);
  if("XOOPS" >< rcvRes)
  {
    sndReq = http_get(item:string(path, '/modules/newbb/viewtopic.php?topic_id' +
            '=14577&forum=2\"><script>foo</script>'), port:xoopsPort);
    rcvRes = http_send_recv(port:xoopsPort, data:sndReq);
    if("<script>foo</script>" >< rcvRes )
    {
      security_warning(xoopsport);
      exit(0);
    }
  }
}
