###################################################################################
#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  Ref : Hobbit <hobbit@avian.org>
#
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
# This script is released under the GNU GPLv2
####################################################################################

if(description)
{
  script_id(14599);
  script_bugtraq_id(6050, 6051);
  script_version ("$Revision: 4340 $");
  script_name("WS FTP server FTP bounce attack and PASV connection hijacking flaw");
  desc = "
  According to its version number, the remote WS_FTP server is vulnerable
  to session hijacking during passive connections and to a FTP bounce
  attack when a user submits a specially crafted FTP command.

  OpenVAS only checked the version number in the server banner

  Solution : Upgrade to the latest version of this software
  Risk factor : High";

  script_description(desc);

  script_summary("Check WS_FTP server version");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("FTP");
  script_dependencie("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include ("ftp_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(! get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port);
if(!banner){
  exit(0);
}
#checking the WS_FTP Server 3.1.3
if(egrep(pattern:"WS_FTP Server ([0-2]\.|3\.(0\.|1\.[0-3][^0-9]))", string: banner)){
  security_hole(port);
}
