##################################################################################
#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 03 $
#
# Updated By:
# Antu Sanadi <santu@secpod.com> on 16/09/2009
#
#
##################################################################################

if(description)
{
  script_id(90024);
  script_version ("$Revision: 03 $");
  script_cve_id("CVE-2007-6026");
  script_bugtraq_id(28398);
  script_name("Windows Vulnerability in Microsoft Jet Database Engine");
  desc = "The remote host is probably affected by the vulnerability described in
  CVE-2007-6026

  Impact
    Stack-based buffer overflow in Microsoft msjet40.dll 4.0.8618.0
    (aka Microsoft Jet Engine), as used by Access 2003 in Microsoft
    Office 2003 SP3, allows user-assisted attackers to execute arbitrary
    code via a crafted MDB file database file containing a column
    structure with a modified column count. NOTE: this might be the
    same issue as CVE-2005-0944.

  References:
    http://www.us-cert.gov/cas/techalerts/TA08-134A.html
    http://securitytracker.com/alerts/2007/Nov/1018976.html
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6026
    http://www.microsoft.com/technet/security/bulletin/ms08-028.mspx

  Solution:
    All Users should upgrade to the latest version.

  Risk factor : High";

  script_description(desc);
  script_summary("Windows Vulnerability in Microsoft Jet Database Engine");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is under GPLv2");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

if((hotfix_missing(name:"950749") == 0)){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath + "\Msjet40.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  #  Grep for Msjet40.dll version < 4.0.9511.0
  if(version_is_less(version:dllVer, test_version:"4.0.9511.0")){
    security_hole(0);
  }
}

# Windows XP
else if(hotfix_check_sp(xp:3) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Msjet40.dll < 4.0.9511.0
    if(version_is_less(version:dllVer, test_version:"4.0.9511.0")){
     security_hole(0);
    }
  }
  else
    security_hole(0);
}

# Windows 2003
else if(hotfix_check_sp(win2003:2) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep for Msjet40.dll version < 4.0.9511.0
    if(version_is_less(version:dllVer, test_version:"4.0.9511.0")){
      security_hole(0);
    }
  }
}
