#
# This script was written by Javier Fernandez-Sanguino
# based on sample code written by Renaud Deraison <deraison@cvs.nessus.org>
# in the nessus-plugins mailing list
#
# under the GPLv2 license or later (at your option)
# 
# Favicons from OWASP Favicon project:
# http://www.owasp.org/index.php/Category:OWASP_Favicon_Database_Project
# awk -F':' '{print "server[\""$1"\"]=\""$2"\";"}' favicon-md5

    desc = "
Synopsis :

The remote web server contains a graphic image that is prone to
information disclosure. 

Description :

The 'favicon.ico' file found on the remote web server belongs to a
popular webserver.  This may be used to fingerprint the web server. 

Solution: 

Remove the 'favicon.ico' file or create a custom one for your site. 

Risk factor: 

Low / CVSS Base Score : 2
(AV:R/AC:L/Au:NR/C:P/A:N/I:N/B:N)";

if(description) {
    script_id(20108); 
    script_version ("$Revision: 5602 $");

    name = "Fingerprint web server with favicon.ico";
    script_name(name);
    summary = "Attempt to fingerprint web server with favicon.ico";
    script_summary(summary);

    script_description(desc);

    script_category(ACT_GATHER_INFO);
    script_copyright("This script is Copyright (C) 2005 Javier Fernandez-Sanguino"); 
    family = "Web application abuses";
    script_family(family);
    script_dependencie("http_version.nasl");
    script_require_ports("Services/www", 80);
    exit(0);
}


# Script code starts here

# Requirements
include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);


# Make the request
req = http_get(item:"/favicon.ico", port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if ( res == NULL ) exit(0);
md5 = hexstr(MD5(res));

# Known favicons list:
# Google Web Server, should not be seen outside Google, and servers as
# a way to test the script
# Various popular CMS, Wikis, ...
server["6399cc480d494bf1fcd7d16c42b1c11b"]="penguin";
server["09b565a51e14b721a323f0ba44b2982a"]="Google web server";
server["506190fc55ceaa132f1bc305ed8472ca"]="SocialText";
server["2cc15cfae55e2bb2d85b57e5b5bc3371"]="PHPwiki";
server["389a8816c5b87685de7d8d5fec96c85b"]="XOOPS cms";
server["e6a9dc66179d8c9f34288b16a02f987e"]="Drupal cms";
server["f1876a80546b3986dbb79bad727b0374"]="NetScreen WebUI";
server["226ffc5e483b85ec261654fe255e60be"]="Netscape 4.1";
server["b25dbe60830705d98ba3aaf0568c456a"]="Netscape iPlanet 6.0";
server["41e2c893098b3ed9fc14b821a2e14e73"]="Netscape 6.0 (AOL)";
server["a28ebcac852795fe30d8e99a23d377c1"]="SunOne 6.1";
server["71e30c507ca3fa005e2d1322a5aa8fb2"]="Apache on Redhat";
server["d41d8cd98f00b204e9800998ecf8427e"]="Zero byte favicon";
server["dcea02a5797ce9e36f19b7590752563e"]="Apache (seen on CentOS/Debian/Fedora)";
server["6f767458b952d4755a795af0e4e0aa17"]="Yahoo!";
server["5b0e3b33aa166c88cee57f83de1d4e55"]="DotNetNuke (http";
server["7dbe9acc2ab6e64d59fa67637b1239df"]="Lotus-Domino";
server["fa54dbf2f61bd2e0188e47f5f578f736"]="Wordpress";
server["6cec5a9c106d45e458fc680f70df91b0"]="Wordpress - obsolete version";
server["81ed5fa6453cf406d1d82233ba355b9a"]="E-zekiel";
server["ecaa88f7fa0bf610a5a26cf545dcd3aa"]="3-byte invalid favicon";
server["4eb846f1286ab4e7a399c851d7d84cca"]="Plone cms";
server["c1201c47c81081c7f0930503cae7f71a"]="vBulletin forum";
server["edaaef7bbd3072a3a0c3fb3b29900bcb"]="Powered by Reynolds Web Solutions (Car sales CMS)";
server["d99217782f41e71bcaa8e663e6302473"]="Apache on Red Hat/Fedora";
server["4644f2d45601037b8423d45e13194c93"]="Apache Tomcat";
server["a8fe5b8ae2c445a33ac41b33ccc9a120"]="Arris Touchstone Device";
server["d16a0da12074dae41980a6918d33f031"]="ST 605";
server["befcded36aec1e59ea624582fcb3225c"]="SpeedTouch";
server["e4a509e78afca846cd0e6c0672797de5"]="i3micro VRG";

# Check the hash against what we know about.
if (server[md5]) {
  if (report_verbosity > 0) {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "The 'favico.ico' fingerprints this webserver as ", server[md5], "."
    );
  }
  else report = desc;

  security_note(port:port, data:report);
  exit(0);
}


# This is a sample script to obtain the list of favicon files from a Webscarab
# directory. Can be useful to add new favicon after a pen-test:
# 
##!/bin/sh
#
#pwd=`pwd`
#find . -name "*response*" |
#while read file ; do
#	if grep -q "^Content-type: image/x-icon" $pwd/$file; then
#	# It's an ico file
#
#	server=`grep --binary-files=text "^Server" $pwd/$file`
#	size=`stat -c %B $pwd/$file`
#		if [ ! -n "$server" ] 
#		then
#			server=`echo $server | sed -e 's/Server: //'`
#		else
#			server="unknown"
#		fi
#	echo "$server,$file,$size"
#	fi
#done

