#
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10758);
 script_version ("$Revision: 4340 $");
 name = "Check for VNC HTTP";
 script_name(name);
 
 desc = "
The remote server is running VNC.
VNC permits a console to be displayed remotely.

Solution: Disable VNC access from the network by 
using a firewall, or stop VNC service if not needed.

Risk factor : Medium";





 script_description(desc);
 
 summary = "Detects the presence of VNC HTTP";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2001 Alert4Web.com");
 family = "Malware";
 script_family(family);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 5800, 5801, 5802);
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");
include("misc_func.inc");

function probe(port)
{
 banner = get_http_banner(port:port);
 if(banner)
 {
  if (("vncviewer.jar" >< banner) || ("vncviewer.class" >< banner))
  {
   security_warning(port);
   set_kb_item(name:"www/vnc", value:TRUE);
  }
 }
}


ports = add_port_in_list(list:get_kb_list("Services/www"), port:5800);
ports = add_port_in_list(list:ports, port:5801);
ports = add_port_in_list(list:ports, port:5802);

foreach port (ports)
{
  probe(port:port);
}

