###############################################################################
# OpenVAS Vulnerability Test
# $Id: viewvc_37518.nasl 6639 2010-02-04 11:53:38Z chandra $
#
# ViewVC Versions Prior to 1.1.3 Multiple Remote Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Updated the CVE.
#  - Rachana Shetty <srachana@secpod.com> on 2010-02-03 #7067
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100414);
 script_cve_id("CVE-2010-0004", "CVE-2010-0005");
 script_bugtraq_id(37518);
 script_version ("1.0-$Revision: 6639 $");
 

 script_name("ViewVC Versions Prior to 1.1.3 Multiple Remote Vulnerabilities");

desc = "Overview:
ViewVC is prone to these security vulnerabilities:

- A security vulnerability that involves root listing of per-root
  authorization configuration.
- A security vulnerability in 'query.py' involving the 'forbidden'
  authorizer (or none).

Versions prior to ViewVC 1.1.3 are vulnerable.

Solution:
Vendor updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37518
http://viewvc.tigris.org/source/browse/viewvc/trunk/CHANGES?rev=HEAD
http://viewvc.tigris.org/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if ViewVC version is < 1.1.3");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("viewvc_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/viewvc")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "1.1.3")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
