###############################################################################
# OpenVAS Vulnerability Test
# $Id: vBulletin_3_7_3_pl1_sql_injection.nasl 88 2009-03-06 17:51:01Z mime $
#
# vBulletin 'admincalendar.php' SQL Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100020);
 script_bugtraq_id(32348);
 script_cve_id("CVE-2008-6256");
 script_version ("1.0");

 script_name("vBulletin 'admincalendar.php' SQL Injection Vulnerability");
 desc = "

 Overview:
  vBulletin is prone to an SQL-injection vulnerability because it
  fails to sufficiently sanitize user-supplied data before using it in
  an SQL query.

  Exploiting this issue could allow an attacker to compromise the
  application, access or modify data, or exploit latent
  vulnerabilities in the underlying database.

  Note that to succeed, the attacker must have an administrative
  account with 'calendar' administrator access.

  vBulletin 3.7.3.pl1 is vulnerable; other versions may also be affected. 

 Solution:
  Upgrade to newest Version of VBulletin.

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if VBulletin 3.7.3.pl1 is running, which is known to be vulnerable to SQL Injection");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("vbulletin_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

version = get_kb_item(string("www/", port, "/vBulletin"));
if (isnull(version)) exit(0);

matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$");

if (!isnull(matches)) {
 ver = matches[1];
 if ( ver <= "3.7.3.pl1" ) {
	security_warning(port:port);
	exit(0);
 }  
}  

exit(0);
