# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-856-1 (cupsys)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(66307);
 script_cve_id("CVE-2009-2820");
 script_version ("$Revision$");
 script_name("Ubuntu USN-856-1 (cupsys)");

 desc = "The remote host is missing an update to cupsys
announced via advisory USN-856-1.

Details follow:

Aaron Sigel discovered that the CUPS web interface incorrectly protected
against cross-site scripting (XSS) and cross-site request forgery (CSRF)
attacks. If an authenticated user were tricked into visiting a malicious
website while logged into CUPS, a remote attacker could modify the CUPS
configuration and possibly steal confidential data.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  cupsys                          1.2.2-0ubuntu0.6.06.15

Ubuntu 8.04 LTS:
  cupsys                          1.3.7-1ubuntu3.6

Ubuntu 8.10:
  cups                            1.3.9-2ubuntu9.3

Ubuntu 9.04:
  cups                            1.3.9-17ubuntu3.4

Ubuntu 9.10:
  cups                            1.4.1-5ubuntu2.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-856-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-856-1 (cupsys)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcupsys2-gnutls10", ver:"1.2.2-0ubuntu0.6.06.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.2.2-0ubuntu0.6.06.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.2.2-0ubuntu0.6.06.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys", ver:"1.2.2-0ubuntu0.6.06.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.2.2-0ubuntu0.6.06.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.2.2-0ubuntu0.6.06.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.2.2-0ubuntu0.6.06.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.2.2-0ubuntu0.6.06.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-common", ver:"1.3.7-1ubuntu3.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.3.7-1ubuntu3.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.3.7-1ubuntu3.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys", ver:"1.3.7-1ubuntu3.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.3.7-1ubuntu3.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.3.7-1ubuntu3.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.3.7-1ubuntu3.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.3.7-1ubuntu3.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-common", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-dbg", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-common", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-bsd", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-client", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-dbg", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcups2-dev", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcups2", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.3.9-2ubuntu9.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-common", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-dbg", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-common", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-bsd", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-client", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-dbg", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcups2-dev", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcups2", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.3.9-17ubuntu3.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-common", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-dbg", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsddk", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-common", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-bsd", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-client", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-dbg", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcups2-dev", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcups2", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupscgi1-dev", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupscgi1", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsdriver1-dev", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsdriver1", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsmime1-dev", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsmime1", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsppdc1-dev", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsppdc1", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cups-ppdc", ver:"1.4.1-5ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
