###############################################################################
# OpenVAS Vulnerability Test
# $Id: thin_webserver_detect.nasl 5474 2009-10-11 17:51:15Z mime $
#
# Thin Webserver Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running Thin, a Ruby web server.

See also:
http://code.macournoyer.com/thin/

Risk factor : None";

if (description)
{
 script_id(100300);
 script_version ("1.0-$Revision: 5474 $");

 script_name("Thin Webserver Detection");
 script_description(desc);
 script_summary("Checks for the presence of Thin Webserver");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 3000);
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:3000);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port:port);
if("Server: thin" >!< banner)exit(0);

    vers = string("unknown");
    ### try to get version 
    version = eregmatch(string: banner, pattern: "Server: thin ([0-9.]+)",icase:TRUE);

    if ( !isnull(version[1]) ) {
       vers=chomp(version[1]);
    }

    set_kb_item(name: string("www/", port, "/thin"), value: string(vers));

    info = string("None\n\nThin Version '");
    info += string(vers);
    info += string("' was detected on the remote host\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 

exit(0);

