#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  This script is released under the GNU GPL v2
#
# kst-depend-misc

if(description)
{
 script_id(80019);
 script_version("$Revision: 1.1 $");
 
 name = "Symantec Web Security Detection";

 script_name(name);
 
 desc = "
Synopsis :

The remote service filters HTTP / FTP content.

Description :

The remote web server appears to be running Symantec Web Security, 
for filtering traffic of viruses and inappropriate content.

Risk factor : 

None";

 script_description(desc);
 
 summary = "Checks for SWS";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2007 David Maciejak");
 
 family = "Web application abuses";
 script_family(family);
 script_dependencie("httpver.nasl");
 script_require_ports("Services/www", 8002);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_kb_item("Services/www");
if ( ! port ) port = 8002;

if(get_port_state(port))
{
  banner = get_http_banner(port:port);
  if (
    banner && 
    "Server: SWS-" >< banner
  ) {
    ver = strstr(banner, "Server: SWS-") - "Server: SWS-";
    if (ver) ver = ver - strstr(ver, '\r');
    if (ver) ver = ver - strstr(ver, '\n');
    if (ver && ver =~ "^[0-9]") {
      security_note(port);
      set_kb_item(name:string("www/", port, "/SWS"),value:string(ver));
    }
  }
}
