# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SR:2009:005
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63469);
 script_cve_id("CVE-2007-0062", "CVE-2008-5078", "CVE-2008-5138", "CVE-2009-0021", "CVE-2009-0040", "CVE-2009-0049", "CVE-2009-0386", "CVE-2009-0387", "CVE-2009-0397", "CVE-2009-0478", "CVE-2009-0599", "CVE-2009-0600", "CVE-2009-0601");
 script_version ("$");
 name = "SuSE Security Summary SUSE-SR:2009:005";
 script_name(name);

 desc = "The remote host is missing updates announced in
advisory SUSE-SR:2009:005.  SuSE Security Summaries are short
on detail when it comes to the names of packages affected by
a particular bug. Because of this, while this test will detect
out of date packages, it cannot tell you what bugs impact
which packages, or vice versa.

Solution:

Update all out of date packages.

Risk factor : High";

 script_description(desc);

 summary = "SuSE Security Advisory SUSE-SR:2009:005";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "SuSE Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"eID-belgium", rpm:"eID-belgium~2.6.0~73.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.159.0~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-good", rpm:"gstreamer-0_10-plugins-good~0.10.7~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-good-doc", rpm:"gstreamer-0_10-plugins-good-doc~0.10.7~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-good-extra", rpm:"gstreamer-0_10-plugins-good-extra~0.10.7~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-good-lang", rpm:"gstreamer-0_10-plugins-good-lang~0.10.7~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"keyutils", rpm:"keyutils~1.2~80.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"keyutils-devel", rpm:"keyutils-devel~1.2~80.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"keyutils-libs", rpm:"keyutils-libs~1.2~80.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.26~14.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.26~14.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng12-0", rpm:"libpng12-0~1.2.26~14.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nagios", rpm:"nagios~3.0.6~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nagios-devel", rpm:"nagios-devel~3.0.6~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nagios-www", rpm:"nagios-www~3.0.6~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp", rpm:"ntp~4.2.4p4~44.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-doc", rpm:"ntp-doc~4.2.4p4~44.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam_mount", rpm:"pam_mount~0.35~15.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.0~17.9", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-devel", rpm:"wireshark-devel~1.0.0~17.9", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"eID-belgium", rpm:"eID-belgium~2.5.9~119.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.159.0~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer010-plugins-good", rpm:"gstreamer010-plugins-good~0.10.6~41.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer010-plugins-good-doc", rpm:"gstreamer010-plugins-good-doc~0.10.6~41.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer010-plugins-good-extra", rpm:"gstreamer010-plugins-good-extra~0.10.6~41.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng", rpm:"libpng~1.2.18~15.10", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.18~15.10", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam_mount", rpm:"pam_mount~0.18~84.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~0.99.6~31.15", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-devel", rpm:"wireshark-devel~0.99.6~31.15", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xntp", rpm:"xntp~4.2.4p3~25.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xntp-doc", rpm:"xntp-doc~4.2.4p3~25.2", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
