# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SR:2009:004
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63412);
 script_cve_id("CVE-2006-3835", "CVE-2007-0184", "CVE-2007-0185", "CVE-2007-2377", "CVE-2007-2449", "CVE-2007-2450", "CVE-2007-3382", "CVE-2007-3385", "CVE-2007-3386", "CVE-2007-5333", "CVE-2007-5342", "CVE-2007-5461", "CVE-2007-5613", "CVE-2007-5615", "CVE-2007-6286", "CVE-2008-0002", "CVE-2008-1232", "CVE-2008-1586", "CVE-2008-1947", "CVE-2008-2235", "CVE-2008-2370", "CVE-2008-2938", "CVE-2008-3231", "CVE-2008-3651", "CVE-2008-3652", "CVE-2008-3663", "CVE-2008-3796", "CVE-2008-4577", "CVE-2008-5086", "CVE-2008-5233", "CVE-2008-5234", "CVE-2008-5235", "CVE-2008-5236", "CVE-2008-5237", "CVE-2008-5238", "CVE-2008-5239", "CVE-2008-5240", "CVE-2008-5241", "CVE-2008-5242", "CVE-2008-5243", "CVE-2008-5244", "CVE-2008-5245", "CVE-2008-5246", "CVE-2008-5247", "CVE-2008-5248", "CVE-2008-5250", "CVE-2008-5252", "CVE-2008-5256", "CVE-2008-5302", "CVE-2008-5557", "CVE-2008-5587", "CVE-2008-5658", "CVE-2008-5718", "CVE-2009-0030", "CVE-2009-0310", "CVE-2009-0313", "CVE-2009-0416", "CVE-2009-0490");
 script_version ("$");
 name = "SuSE Security Summary SUSE-SR:2009:004";
 script_name(name);

 desc = "The remote host is missing updates announced in
advisory SUSE-SR:2009:004.  SuSE Security Summaries are short
on detail when it comes to the names of packages affected by
a particular bug. Because of this, while this test will detect
out of date packages, it cannot tell you what bugs impact
which packages, or vice versa.

Solution:

Update all out of date packages.

Risk factor : High";

 script_description(desc);

 summary = "SuSE Security Advisory SUSE-SR:2009:004";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "SuSE Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.6~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-branding-upstream", rpm:"MozillaFirefox-branding-upstream~3.0.6~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.6~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aaa_base", rpm:"aaa_base~11.1~10007.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport", rpm:"apport~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-crashdb-opensuse", rpm:"apport-crashdb-opensuse~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-gtk", rpm:"apport-gtk~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-qt", rpm:"apport-qt~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-retrace", rpm:"apport-retrace~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi", rpm:"at-spi~1.24.0~2.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi-devel", rpm:"at-spi-devel~1.24.0~2.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi-doc", rpm:"at-spi-doc~1.24.0~2.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi-lang", rpm:"at-spi-lang~1.24.0~2.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audacity", rpm:"audacity~1.3.5~49.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile", rpm:"audiofile~0.2.6~142.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile-devel", rpm:"audiofile-devel~0.2.6~142.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compat-openssl097g", rpm:"compat-openssl097g~0.9.7g~146.9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dice", rpm:"dice~0.1.9~1.3.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dice-debug", rpm:"dice-debug~0.1.9~1.3.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dice-devel", rpm:"dice-devel~0.1.9~1.3.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glade3", rpm:"glade3~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glade3-lang", rpm:"glade3-lang~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc", rpm:"glibc~2.9~2.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-devel", rpm:"glibc-devel~2.9~2.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-html", rpm:"glibc-html~2.9~2.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-i18ndata", rpm:"glibc-i18ndata~2.9~2.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-info", rpm:"glibc-info~2.9~2.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-locale", rpm:"glibc-locale~2.9~2.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-obsolete", rpm:"glibc-obsolete~2.9~2.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-profile", rpm:"glibc-profile~2.9~2.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-packagekit", rpm:"gnome-packagekit~0.3.11~2.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-packagekit-lang", rpm:"gnome-packagekit-lang~0.3.11~2.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel", rpm:"gnome-panel~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-devel", rpm:"gnome-panel-devel~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-doc", rpm:"gnome-panel-doc~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-extras", rpm:"gnome-panel-extras~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-lang", rpm:"gnome-panel-lang~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2", rpm:"gtk2~2.14.4~8.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-branding-upstream", rpm:"gtk2-branding-upstream~2.14.4~8.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-devel", rpm:"gtk2-devel~2.14.4~8.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-doc", rpm:"gtk2-doc~2.14.4~8.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-lang", rpm:"gtk2-lang~2.14.4~8.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun", rpm:"java-1_6_0-sun~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-alsa", rpm:"java-1_6_0-sun-alsa~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-devel", rpm:"java-1_6_0-sun-devel~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-jdbc", rpm:"java-1_6_0-sun-jdbc~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-plugin", rpm:"java-1_6_0-sun-plugin~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-src", rpm:"java-1_6_0-sun-src~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libQtWebKit-devel", rpm:"libQtWebKit-devel~4.4.3~4.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libQtWebKit4", rpm:"libQtWebKit4~4.4.3~4.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgladeui-1-8", rpm:"libgladeui-1-8~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgladeui-1_0-devel", rpm:"libgladeui-1_0-devel~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgladeui-1_0-doc", rpm:"libgladeui-1_0-doc~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libipulog-devel", rpm:"libipulog-devel~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpython2_6-1_0", rpm:"libpython2_6-1_0~2.6.0~2.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqdialogsolver1", rpm:"libqdialogsolver1~1.2.6~1.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqdialogsolver1-devel", rpm:"libqdialogsolver1-devel~1.2.6~1.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4", rpm:"libqt4~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-devel", rpm:"libqt4-devel~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-devel-doc", rpm:"libqt4-devel-doc~4.4.3~4.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-qt3support", rpm:"libqt4-qt3support~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql", rpm:"libqt4-sql~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-mysql", rpm:"libqt4-sql-mysql~4.4.3~11.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-postgresql", rpm:"libqt4-sql-postgresql~4.4.3~11.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-sqlite", rpm:"libqt4-sql-sqlite~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-unixODBC", rpm:"libqt4-sql-unixODBC~4.4.3~11.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-x11", rpm:"libqt4-x11~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsatsolver-devel", rpm:"libsatsolver-devel~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff-devel", rpm:"libtiff-devel~3.8.2~133.35.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff3", rpm:"libtiff3~3.8.2~133.35.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt", rpm:"libvirt~0.4.6~11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-devel", rpm:"libvirt-devel~0.4.6~11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-doc", rpm:"libvirt-doc~0.4.6~11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-python", rpm:"libvirt-python~0.4.6~11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.7.1~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.7.1~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-doc", rpm:"libxml2-doc~2.7.1~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp", rpm:"libzypp~5.25.3~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp-devel", rpm:"libzypp-devel~5.25.3~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nano", rpm:"nano~2.1.7~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netatalk", rpm:"netatalk~2.0.3~246.13.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netatalk-devel", rpm:"netatalk-devel~2.0.3~246.13.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-client", rpm:"nfs-client~1.1.3~18.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-doc", rpm:"nfs-doc~1.1.3~18.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-kernel-server", rpm:"nfs-kernel-server~1.1.3~18.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nscd", rpm:"nscd~2.9~2.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp", rpm:"openslp~1.2.0~168.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp-devel", rpm:"openslp-devel~1.2.0~168.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp-server", rpm:"openslp-server~1.2.0~168.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"parted", rpm:"parted~1.8.8~91.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"parted-devel", rpm:"parted-devel~1.8.8~91.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl", rpm:"perl~5.10.0~62.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-base", rpm:"perl-base~5.10.0~62.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-doc", rpm:"perl-doc~5.10.0~62.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-satsolver", rpm:"perl-satsolver~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5", rpm:"php5~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bz2", rpm:"php5-bz2~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-calendar", rpm:"php5-calendar~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ctype", rpm:"php5-ctype~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dbase", rpm:"php5-dbase~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gettext", rpm:"php5-gettext~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gmp", rpm:"php5-gmp~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-hash", rpm:"php5-hash~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-json", rpm:"php5-json~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mcrypt", rpm:"php5-mcrypt~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ncurses", rpm:"php5-ncurses~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-openssl", rpm:"php5-openssl~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pcntl", rpm:"php5-pcntl~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pdo", rpm:"php5-pdo~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-posix", rpm:"php5-posix~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pspell", rpm:"php5-pspell~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-readline", rpm:"php5-readline~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-shmop", rpm:"php5-shmop~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-snmp", rpm:"php5-snmp~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sockets", rpm:"php5-sockets~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sqlite", rpm:"php5-sqlite~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-suhosin", rpm:"php5-suhosin~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvsem", rpm:"php5-sysvsem~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tidy", rpm:"php5-tidy~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tokenizer", rpm:"php5-tokenizer~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlreader", rpm:"php5-xmlreader~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlwriter", rpm:"php5-xmlwriter~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xsl", rpm:"php5-xsl~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zip", rpm:"php5-zip~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zlib", rpm:"php5-zlib~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powerdevil", rpm:"powerdevil~1.4.1~4.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powerdevil-lang", rpm:"powerdevil-lang~1.4.1~4.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ptools", rpm:"ptools~0.1~2.16.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python", rpm:"python~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-base", rpm:"python-base~2.6.0~2.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-curses", rpm:"python-curses~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-demo", rpm:"python-demo~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-devel", rpm:"python-devel~2.6.0~2.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-gdbm", rpm:"python-gdbm~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-idle", rpm:"python-idle~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-m2crypto", rpm:"python-m2crypto~0.17~2.1.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-satsolver", rpm:"python-satsolver~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-tk", rpm:"python-tk~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-xml", rpm:"python-xml~2.6.0~2.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-xpcom190", rpm:"python-xpcom190~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt4-x11-tools", rpm:"qt4-x11-tools~4.4.3~4.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-satsolver", rpm:"ruby-satsolver~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"satsolver-tools", rpm:"satsolver-tools~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sblim-sfcb", rpm:"sblim-sfcb~1.3.2~9.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sysvinit", rpm:"sysvinit~2.86~186.15.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tiff", rpm:"tiff~3.8.2~133.35.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd", rpm:"ulogd~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-mysql", rpm:"ulogd-mysql~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-pcap", rpm:"ulogd-pcap~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-pgsql", rpm:"ulogd-pgsql~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-sqlite", rpm:"ulogd-sqlite~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wine", rpm:"wine~1.1.9~1.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wine-devel", rpm:"wine-devel~1.1.9~1.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2", rpm:"yast2~2.17.59~1.2.13", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-devel-doc", rpm:"yast2-devel-doc~2.17.59~1.2.13", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-pkg-bindings", rpm:"yast2-pkg-bindings~2.17.31~1.2.10", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zypper", rpm:"zypper~1.0.5~2.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.6~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.6~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audacity", rpm:"audacity~1.3.4~56.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp", rpm:"dhcp~3.0.6~86.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-client", rpm:"dhcp-client~3.0.6~86.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-devel", rpm:"dhcp-devel~3.0.6~86.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-relay", rpm:"dhcp-relay~3.0.6~86.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-server", rpm:"dhcp-server~3.0.6~86.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot", rpm:"dovecot~1.0.13~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-devel", rpm:"dovecot-devel~1.0.13~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-packagekit", rpm:"gnome-packagekit~0.2.1~15.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun", rpm:"java-1_6_0-sun~1.6.0.u12~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-alsa", rpm:"java-1_6_0-sun-alsa~1.6.0.u12~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-demo", rpm:"java-1_6_0-sun-demo~1.6.0.u12~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-devel", rpm:"java-1_6_0-sun-devel~1.6.0.u12~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-jdbc", rpm:"java-1_6_0-sun-jdbc~1.6.0.u12~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-plugin", rpm:"java-1_6_0-sun-plugin~1.6.0.u12~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-src", rpm:"java-1_6_0-sun-src~1.6.0.u12~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libQtWebKit-devel", rpm:"libQtWebKit-devel~4.4.0~12.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libQtWebKit4", rpm:"libQtWebKit4~4.4.0~12.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libipulog", rpm:"libipulog~1.24~101.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4", rpm:"libqt4~4.4.0~12.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-devel", rpm:"libqt4-devel~4.4.0~12.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-devel-doc", rpm:"libqt4-devel-doc~4.4.0~12.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-qt3support", rpm:"libqt4-qt3support~4.4.0~12.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql", rpm:"libqt4-sql~4.4.0~12.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-mysql", rpm:"libqt4-sql-mysql~4.4.0~5.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-postgresql", rpm:"libqt4-sql-postgresql~4.4.0~5.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-sqlite", rpm:"libqt4-sql-sqlite~4.4.0~12.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-unixODBC", rpm:"libqt4-sql-unixODBC~4.4.0~5.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-x11", rpm:"libqt4-x11~4.4.0~12.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsatsolver-devel", rpm:"libsatsolver-devel~0.9.6~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsatsolver-perl", rpm:"libsatsolver-perl~0.9.6~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsatsolver-ruby", rpm:"libsatsolver-ruby~0.9.6~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff-devel", rpm:"libtiff-devel~3.8.2~108.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff3", rpm:"libtiff3~3.8.2~108.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt", rpm:"libvirt~0.4.0~59.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-devel", rpm:"libvirt-devel~0.4.0~59.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-doc", rpm:"libvirt-doc~0.4.0~59.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-python", rpm:"libvirt-python~0.4.0~59.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.6.32~11.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.6.32~11.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-doc", rpm:"libxml2-doc~2.6.32~11.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp", rpm:"libzypp~4.28.1~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp-devel", rpm:"libzypp-devel~4.28.1~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mediawiki", rpm:"mediawiki~1.11.2~36.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.6~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.6~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.6~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.6~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netatalk", rpm:"netatalk~2.0.3~218.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netatalk-devel", rpm:"netatalk-devel~2.0.3~218.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"novell-ipsec-tools", rpm:"novell-ipsec-tools~0.6.3~183.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"novell-ipsec-tools-devel", rpm:"novell-ipsec-tools-devel~0.6.3~183.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp", rpm:"openslp~1.2.0~143.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp-devel", rpm:"openslp-devel~1.2.0~143.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp-server", rpm:"openslp-server~1.2.0~143.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl", rpm:"perl~5.10.0~37.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-base", rpm:"perl-base~5.10.0~37.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-doc", rpm:"perl-doc~5.10.0~37.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5", rpm:"php5~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bz2", rpm:"php5-bz2~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-calendar", rpm:"php5-calendar~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ctype", rpm:"php5-ctype~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dbase", rpm:"php5-dbase~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gettext", rpm:"php5-gettext~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gmp", rpm:"php5-gmp~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-hash", rpm:"php5-hash~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-json", rpm:"php5-json~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mcrypt", rpm:"php5-mcrypt~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ncurses", rpm:"php5-ncurses~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-openssl", rpm:"php5-openssl~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pcntl", rpm:"php5-pcntl~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pdo", rpm:"php5-pdo~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-posix", rpm:"php5-posix~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pspell", rpm:"php5-pspell~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-readline", rpm:"php5-readline~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-shmop", rpm:"php5-shmop~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-snmp", rpm:"php5-snmp~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sockets", rpm:"php5-sockets~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sqlite", rpm:"php5-sqlite~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-suhosin", rpm:"php5-suhosin~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvsem", rpm:"php5-sysvsem~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tidy", rpm:"php5-tidy~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tokenizer", rpm:"php5-tokenizer~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlreader", rpm:"php5-xmlreader~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlwriter", rpm:"php5-xmlwriter~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xsl", rpm:"php5-xsl~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zip", rpm:"php5-zip~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zlib", rpm:"php5-zlib~5.2.6~0.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt4-x11-tools", rpm:"qt4-x11-tools~4.4.0~12.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"satsolver-tools", rpm:"satsolver-tools~0.9.6~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sbl", rpm:"sbl~3.2.2~16.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sbl-orca", rpm:"sbl-orca~3.2.2~16.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sblim-sfcb", rpm:"sblim-sfcb~1.3.0~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"swfdec", rpm:"swfdec~0.6.8~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"swfdec-devel", rpm:"swfdec-devel~0.6.8~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"swfdec-doc", rpm:"swfdec-doc~0.6.8~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tiff", rpm:"tiff~3.8.2~108.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd", rpm:"ulogd~1.24~101.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-mysql", rpm:"ulogd-mysql~1.24~101.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-pcap", rpm:"ulogd-pcap~1.24~101.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-pgsql", rpm:"ulogd-pgsql~1.24~101.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-sqlite", rpm:"ulogd-sqlite~1.24~101.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-ose", rpm:"virtualbox-ose~1.5.6~33.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-ose-guest-tools", rpm:"virtualbox-ose-guest-tools~1.5.6~33.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wine", rpm:"wine~0.9.64_aka_1.0.rc3~2.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wine-devel", rpm:"wine-devel~0.9.64_aka_1.0.rc3~2.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-devel", rpm:"xine-devel~1.1.12~8.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-extra", rpm:"xine-extra~1.1.12~8.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.12~8.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-driver-virtualbox-ose", rpm:"xorg-x11-driver-virtualbox-ose~1.5.6~33.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-gtk", rpm:"yast2-gtk~2.16.15~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-ncurses-pkg", rpm:"yast2-ncurses-pkg~2.16.14~0.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-packager", rpm:"yast2-packager~2.16.53~3.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-pkg-bindings", rpm:"yast2-pkg-bindings~2.16.42~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-qt-pkg", rpm:"yast2-qt-pkg~2.16.48~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audacity", rpm:"audacity~1.3.3~46.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp", rpm:"dhcp~3.0.6~24.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-client", rpm:"dhcp-client~3.0.6~24.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-devel", rpm:"dhcp-devel~3.0.6~24.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-relay", rpm:"dhcp-relay~3.0.6~24.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-server", rpm:"dhcp-server~3.0.6~24.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot", rpm:"dovecot~1.0.5~6.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-devel", rpm:"dovecot-devel~1.0.5~6.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun", rpm:"java-1_6_0-sun~1.6.0.u12~1.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-alsa", rpm:"java-1_6_0-sun-alsa~1.6.0.u12~1.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-debuginfo", rpm:"java-1_6_0-sun-debuginfo~1.6.0.u12~1.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-demo", rpm:"java-1_6_0-sun-demo~1.6.0.u12~1.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-devel", rpm:"java-1_6_0-sun-devel~1.6.0.u12~1.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-jdbc", rpm:"java-1_6_0-sun-jdbc~1.6.0.u12~1.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-plugin", rpm:"java-1_6_0-sun-plugin~1.6.0.u12~1.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-src", rpm:"java-1_6_0-sun-src~1.6.0.u12~1.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libipulog", rpm:"libipulog~1.24~36.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff-devel", rpm:"libtiff-devel~3.8.2~68.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff3", rpm:"libtiff3~3.8.2~68.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt", rpm:"libvirt~0.3.0~30.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-devel", rpm:"libvirt-devel~0.3.0~30.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-doc", rpm:"libvirt-doc~0.3.0~30.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-python", rpm:"libvirt-python~0.3.0~30.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.6.30~4.11", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.6.30~4.11", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mediawiki", rpm:"mediawiki~1.10.0~32.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netatalk", rpm:"netatalk~2.0.3~130.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netatalk-devel", rpm:"netatalk-devel~2.0.3~130.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"novell-ipsec-tools", rpm:"novell-ipsec-tools~0.6.3~114.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"novell-ipsec-tools-devel", rpm:"novell-ipsec-tools-devel~0.6.3~114.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp", rpm:"openslp~1.2.0~96.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp-devel", rpm:"openslp-devel~1.2.0~96.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp-server", rpm:"openslp-server~1.2.0~96.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5", rpm:"php5~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bz2", rpm:"php5-bz2~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-calendar", rpm:"php5-calendar~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ctype", rpm:"php5-ctype~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dbase", rpm:"php5-dbase~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gettext", rpm:"php5-gettext~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gmp", rpm:"php5-gmp~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-hash", rpm:"php5-hash~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-json", rpm:"php5-json~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mcrypt", rpm:"php5-mcrypt~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mhash", rpm:"php5-mhash~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ncurses", rpm:"php5-ncurses~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-openssl", rpm:"php5-openssl~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pcntl", rpm:"php5-pcntl~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pdo", rpm:"php5-pdo~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-posix", rpm:"php5-posix~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pspell", rpm:"php5-pspell~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-readline", rpm:"php5-readline~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-shmop", rpm:"php5-shmop~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-snmp", rpm:"php5-snmp~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sockets", rpm:"php5-sockets~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sqlite", rpm:"php5-sqlite~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-suhosin", rpm:"php5-suhosin~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvsem", rpm:"php5-sysvsem~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tidy", rpm:"php5-tidy~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tokenizer", rpm:"php5-tokenizer~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlreader", rpm:"php5-xmlreader~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlwriter", rpm:"php5-xmlwriter~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xsl", rpm:"php5-xsl~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zip", rpm:"php5-zip~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zlib", rpm:"php5-zlib~5.2.6~0.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sbl", rpm:"sbl~3.0f~16.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tiff", rpm:"tiff~3.8.2~68.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd", rpm:"ulogd~1.24~36.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-mysql", rpm:"ulogd-mysql~1.24~36.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-pcap", rpm:"ulogd-pcap~1.24~36.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-pgsql", rpm:"ulogd-pgsql~1.24~36.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-sqlite", rpm:"ulogd-sqlite~1.24~36.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox", rpm:"virtualbox~1.5.2~10.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-guest-tools", rpm:"virtualbox-guest-tools~1.5.2~10.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-devel", rpm:"xine-devel~1.1.8~14.11", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-extra", rpm:"xine-extra~1.1.8~14.11", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.8~14.11", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-driver-virtualbox", rpm:"xorg-x11-driver-virtualbox~1.5.2~10.4", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
