# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SA:2009:026 (glib2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63890);
 script_cve_id("CVE-2008-4316");
 script_version ("$");
 name["english"] = "SuSE Security Advisory SUSE-SA:2009:026 (glib2)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory SUSE-SA:2009:026.

The advisory was resent because the previous one contained the wrong
Announcement ID.

The code library glib2 provides base64 encoding and decoding functions
that are vulnerable to integer overflows when processing very large strings.

Processes using this library functions for processing data from the network
can be exploited remotely to execute arbitrary code with the privileges of
the user running this process.

Solution:
Update your system with the packages as indicated in
the referenced security advisory.

https://secure1.securityspace.com/smysecure/catid.html?in=SUSE-SA:2009:026

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "SuSE Security Advisory SUSE-SA:2009:026 (glib2)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"glib2-debuginfo", rpm:"glib2-debuginfo~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-debugsource", rpm:"glib2-debugsource~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-branding-upstream", rpm:"glib2-branding-upstream~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-doc", rpm:"glib2-doc~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-lang", rpm:"glib2-lang~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-2_0-0", rpm:"libgio-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-fam", rpm:"libgio-fam~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libglib-2_0-0", rpm:"libglib-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgmodule-2_0-0", rpm:"libgmodule-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgobject-2_0-0", rpm:"libgobject-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgthread-2_0-0", rpm:"libgthread-2_0-0~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-debuginfo", rpm:"glib2-debuginfo~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-debugsource", rpm:"glib2-debugsource~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-branding-upstream", rpm:"glib2-branding-upstream~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-doc", rpm:"glib2-doc~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-lang", rpm:"glib2-lang~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-2_0-0", rpm:"libgio-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-fam", rpm:"libgio-fam~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libglib-2_0-0", rpm:"libglib-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgmodule-2_0-0", rpm:"libgmodule-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgobject-2_0-0", rpm:"libgobject-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgthread-2_0-0", rpm:"libgthread-2_0-0~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-doc", rpm:"glib2-doc~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-lang", rpm:"glib2-lang~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-debuginfo-64bit", rpm:"glib2-debuginfo-64bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-2_0-0-64bit", rpm:"libgio-2_0-0-64bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libglib-2_0-0-64bit", rpm:"libglib-2_0-0-64bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgmodule-2_0-0-64bit", rpm:"libgmodule-2_0-0-64bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgobject-2_0-0-64bit", rpm:"libgobject-2_0-0-64bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgthread-2_0-0-64bit", rpm:"libgthread-2_0-0-64bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel-64bit", rpm:"glib2-devel-64bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-2_0-0-64bit", rpm:"libgio-2_0-0-64bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libglib-2_0-0-64bit", rpm:"libglib-2_0-0-64bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgmodule-2_0-0-64bit", rpm:"libgmodule-2_0-0-64bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgobject-2_0-0-64bit", rpm:"libgobject-2_0-0-64bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgthread-2_0-0-64bit", rpm:"libgthread-2_0-0-64bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-64bit", rpm:"glib2-64bit~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel-64bit", rpm:"glib2-devel-64bit~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-debuginfo-32bit", rpm:"glib2-debuginfo-32bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-2_0-0-32bit", rpm:"libgio-2_0-0-32bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libglib-2_0-0-32bit", rpm:"libglib-2_0-0-32bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgmodule-2_0-0-32bit", rpm:"libgmodule-2_0-0-32bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgobject-2_0-0-32bit", rpm:"libgobject-2_0-0-32bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgthread-2_0-0-32bit", rpm:"libgthread-2_0-0-32bit~2.18.2~5.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-2_0-0-32bit", rpm:"libgio-2_0-0-32bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libglib-2_0-0-32bit", rpm:"libglib-2_0-0-32bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgmodule-2_0-0-32bit", rpm:"libgmodule-2_0-0-32bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgobject-2_0-0-32bit", rpm:"libgobject-2_0-0-32bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgthread-2_0-0-32bit", rpm:"libgthread-2_0-0-32bit~2.16.3~20.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-32bit", rpm:"glib2-32bit~2.14.1~4.4", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
