###############################################################################
# OpenVAS Vulnerability Test
# $Id: ssh_proto_version.nasl 6984 2010-03-17 12:20:23Z mime $
#
# SSH Protocol Versions Supported
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.

desc = "

Overview:
The remote SSH Server supports the following SSH Protocol Versions:

Risk factor : None";

if (description)
{
 script_id(100259);
 script_version ("1.0");

 script_name("SSH Protocol Versions Supported");
 script_description(desc);
 script_summary("Checks for the supported SSH Protocol Versions");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("ssh_detect.nasl");
 script_require_ports("Services/ssh", 22);
 exit(0);
}

include("global_settings.inc");
include("ssh_func.inc");

port = get_kb_item("Services/ssh");
if(!port)port = 22;

if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);
close(soc);

function read_key(key) {

 local_var key, len, fingerprint, x;

  key_hex = hexstr(MD5(key));
  len = strlen(key_hex); # 32

  for(x = 0; x < len; x += 2) {
    fingerprint += substr(key_hex,x,x+1);
    if(x+2<len) {
       fingerprint += ":";
     }
  }  
 if("ssh-rsa" >< key) {
   set_kb_item(name:string("SSH/",port,"/fingerprint/ssh-rsa"), value:fingerprint);
 } 
 if("ssh-dss" >< key) {
   set_kb_item(name:string("SSH/",port,"/fingerprint/ssh-dss"), value:fingerprint);
 }  

 return fingerprint;

}

function get_fingerprint(version) {

 local_var buf, header, fingerprint, key, len, version, soc;

 soc = open_sock_tcp(port);
 if(!soc)return FALSE;

 if(version == "2.0") {

   ssh_login(socket:soc);
   key = get_server_host_key();

   close(soc);
   if(!key)return FALSE;

   if(fingerprint = read_key(key:key)) {
     return fingerprint;
   } else {
     return FALSE;
   }
  } 

 else if(version == "1.5") {

   buf = recv_line(socket:soc, length:8192);
   send(socket:soc, data:'SSH-1.5-OpenVAS_1.0\n');

   header = recv(socket:soc, length:4);
   if(strlen(header)<4)return FALSE;

   len = ord(header[2])*256+ord(header[3]);
   buf = recv(socket:soc, length:len);
   if(!buf)return FALSE;
   buf = header + buf;

   close(soc);

   if(!key = substr(buf,132,259)+raw_string(0x23))return FALSE;
   if(fingerprint = read_key(key:key)) {
      return fingerprint;
   } else {
      return FALSE;
   }
 }
 else {
   close(soc);
   return FALSE;
 }
  return fingerprint;
}

versionen = make_list("1.33","1.5","1.99","2.0");

foreach version (versionen) {

  soc = open_sock_tcp(port);
  if(!soc)exit(0);

  ret = recv_line(socket:soc, length:512);
  if(!ret) {
    close(soc);
    exit(0);
  }

  if(!egrep(pattern:"^SSH-.*", string:ret)){
    close(soc);
    return(0);
  }

  request = string("SSH-", version, "-OpenVASSSH_1.0\n");
  send(socket:soc, data:request);

  ret = recv_line(socket:soc, length:500);
  close(soc);

  if(!egrep(pattern:"Protocol.*differ", string: ret)) {
   supported_versions[version]=version; 
  }   
}

if((report_verbosity > 0) && (supported_versions)) {
  
  foreach supported (supported_versions) {
   if(supported == "2.0" || supported == "1.5") {
     if(fingerprint = get_fingerprint(version:supported)) {
       if(supported == "2.0") {
         fingerprint_info += string("SSHv2 Fingerprint: ", fingerprint, "\n");
	 set_kb_item(name: string("SSH/",port,"/fingerprint/v2"), value: fingerprint);
       } 
       else if(supported == "1.5") {
         fingerprint_info += string("SSHv1 Fingerprint: ", fingerprint, "\n");
	 set_kb_item(name: string("SSH/",port,"/fingerprint/v1"), value: fingerprint);
       }
     }
   }
   info += string(chomp(supported),"\n");
  }

  if(fingerprint_info) {
    info += string("\n", fingerprint_info);
  }

  info += string("\n\nRisk factor : None\n");
  set_kb_item(name:"SSH/supportedversions/" + port,value: supported_versions);
  
  desc = ereg_replace(
         string:desc,
         pattern:"Risk factor : None$",
         replace:info);

         security_note(port:port,data:desc);
	 exit(0);
}

exit(0);

