###############################################################################
# OpenVAS Vulnerability Test
# $Id: squid_37522.nasl 6306 2010-01-04 17:09:12Z mime $
#
# Squid Header-Only Packets Remote Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100412);
 script_bugtraq_id(37522);
 script_version ("1.0-$Revision: 6306 $");

 script_name("Squid Header-Only Packets Remote Denial of Service Vulnerability");

desc = "Overview:
Squid is prone to a remote denial-of-service vulnerability.

An attacker can exploit this to issue to crash the affected
application, denying service to legitimate users.

References:
http://www.securityfocus.com/bid/37522
http://events.ccc.de/congress/2009/Fahrplan//attachments/1483_26c3_ipv4_fuckups.pdf
http://www.squid-cache.org/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Squid version is <= 3.1.5");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("secpod_squid_detect.nasl");
 script_require_ports("Services/www","Services/http_proxy",3128,8080);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_kb_item("Services/http_proxy");

if(!port){
  exit(0);
}

if(!vers = get_kb_item(string("www/", port, "/Squid")))exit(0);

if(!isnull(vers)) {
  if(version_is_less(version: vers, test_version: "3.1.5")) {
    security_warning(port: port);
    exit(0);
  }   
}  

exit(0);
