###############################################################################
# OpenVAS Vulnerability Test
# $Id: squid_35812.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Squid Multiple Remote Denial of Service Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100249);
 script_bugtraq_id(35812);
 script_version ("1.0");

 script_name("Squid Multiple Remote Denial of Service Vulnerabilities");

desc = "

Overview:
Squid is prone to multiple remote denial-of-service vulnerabilities.

Successfully exploiting these issues allow remote attackers to crash
the affected application, denying further service to legitimate users.

This issue affects Squid 3.0.STABLE16, 3.1.0.11 and prior versions.


Solution:
Updates are available. Please see the references for more information.


References:
http://www.securityfocus.com/bid/35812
http://www.squid-cache.org/Advisories/SQUID-2009_2.txt
http://www.squid-cache.org/


Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Squid version is <=3.0.STABLE16 or <=3.1.0.11");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("secpod_squid_detect.nasl");
 script_require_ports("Services/www", 3128, 8080);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_kb_item("Services/http_proxy");

if(!port){
    exit(0);
}

if(!vers = get_kb_item(string("www/", port, "/Squid")))exit(0);

if(!isnull(vers)) {

  if(version_in_range(version:vers, test_version:"3.1.0", test_version2:"3.1.0.11") ||
     version_in_range(version:vers, test_version:"3.1", test_version2:"3.1.5")      ||
     version_in_range(version:vers, test_version:"3.0", test_version2:"3.0.STABLE16")) {

      security_warning(port:port);
      exit(0);

  }

}

exit(0);
