#
# Script Written By Ferdy Riphagen 
# Script distributed under the GNU GPLv2 License. 
# Modified by Michael Meyer <michael.meyer@intevation.de>

if (description) {
 script_id(80044);
 script_version("$Revision: 1.1 $");

 desc = "Overview: This script detects the installed version of
SonicWall Global VPN Client and sets the result in KB.

Risk Factor: Informational";

 script_description(desc);

 name = "SonicWall Global VPN Client Detection";
 script_name(name);
 summary = "Detects the presence and version of the SNWL Global VPN Client";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2008 Ferdy Riphagen");

 script_require_ports(139, 445);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/login", "SMB/password", "SMB/name", "SMB/transport");
 exit(0);
}

include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
   exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\SWGVpnClient.exe";

if(!registry_key_exists(key:key)){
    exit(0);
}

path = registry_get_sz(key:key, item:"Path");

if(path) {

  file = path + "\SWGVpnClient.exe";
  version = GetVersionFromFile(file:file,verstr:"prod");
  if(!isnull(version)){
    set_kb_item(name:"SMB/SonicWallGlobalVPNClient/Version", value:version);
    set_kb_item(name:"SMB/SonicWallGlobalVPNClient/Path", value:path);
    exit(0);
  }  
}  

exit(0);
