#
# This script was written by Michael Scheidell SECNAP Network Security
#
# See the Nessus Scripts License for details
#
if(description)
{
 script_id(11091);
 script_bugtraq_id(5480);
 script_version("$Revision: 4336 $");
 script_cve_id("CVE-2002-0720");
 name = "Windows Network Manager Privilege Elevation (Q326886)";
 
 script_name(name);
 
 desc = "
A flaw in the Windows 2000 Network Connection Manager
could enable privilege elevation.

Impact of vulnerability: Elevation of Privilege 

Affected Software: 

Microsoft Windows 2000 

Recommendation: Users using any of the affected
products should install the patch immediately.

Maximum Severity Rating: Critical

See
http://www.microsoft.com/technet/security/bulletin/ms02-042.mspx

Risk factor : High";

 script_description(desc);
 
 summary = "Checks for MS Hotfix Q326886, Network Elevated Privilege";

 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2002 SECNAP Nework Security, LLC");
 family = "Windows : Microsoft Bulletins";
 script_family(family);
 
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("secpod_reg.inc");

if ( hotfix_check_sp(win2k:4) <= 0 ) exit(0);
if ( hotfix_missing(name:"Q326886") > 0 )
	security_hole(get_kb_item("SMB/transport"));

