#
# This script was written by Michael Scheidell <scheidell at secnap.net>
#
# See the Nessus Scripts License for details
#
if(description)
{
 script_id(10964);
 script_bugtraq_id(4287);
 script_version("$Revision: 4336 $");
 script_cve_id("CVE-2002-0367");
 name = "Windows Debugger flaw can Lead to Elevated Privileges (Q320206)";
 
 script_name(name);
 
 desc = "
Authentication Flaw in Windows Debugger can Lead to Elevated 
Privileges (Q320206)

Impact of vulnerability: Elevation of Privilege 

Affected Software: 

Microsoft Windows NT 4.0 
Microsoft Windows NT 4.0 Server, Terminal Server Edition 
Microsoft Windows 2000 

Recommendation: Users using any of the affected
products should install the patch immediately.

Maximum Severity Rating: Critical (locally)

See
http://www.microsoft.com/technet/security/bulletin/ms02-024.mspx

Risk factor : High";

 script_description(desc);
 
 summary = "Checks for MS Hotfix Q320206, Elevated Privilege";

 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2002 Michael Scheidell");
 family = "Windows : Microsoft Bulletins";
 script_family(family);
 
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("secpod_reg.inc");

if ( hotfix_check_sp(nt:7, win2k:3) <= 0 ) exit(0);
if ( hotfix_missing(name:"Q320206") > 0 )
	security_hole(get_kb_item("SMB/transport"));

