##############################################################################
#
#  SMB log in
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/09
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0003
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(10394);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version ("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family("Windows");
 script_name("SMB log in");
 script_summary("Attempts to log into the remote host");
 desc = "
 This script attempts to logon into the remote host using 
 login/password credentials.

 Risk factor : Informational";
 script_description(desc);
 script_dependencies("netbios_name_get.nasl", "cifs445.nasl",
		     "find_service.nes", "logins.nasl");
 script_require_keys("SMB/name", "SMB/transport");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 
 port = kb_smb_transport();
 if(!port){
	port = 139;
 }

 name = kb_smb_name();
 if(!name){
        name = "*SMBSERVER";
 }

 if(!get_port_state(port)){
        exit(0);
 }

 login =  string(get_kb_item("SMB/login_filled/0"));
 password = string(get_kb_item("SMB/password_filled/0"));
 user_domain = string(get_kb_item("SMB/domain_filled/0"));

 if(!strlen(login)){
	login ="";
 }

 if(!strlen(password)){
        password = "";
 }

 if(strlen(user_domain)){
	domain = user_domain;
 }

 if(!strlen(user_domain)){
        user_domain = "";
 
        soc = open_sock_tcp(port);
        if(!soc){
                exit(0);
        }

        smb_session_request(soc:soc, remote:name);

        prot = smb_neg_prot(soc:soc);
        close(soc);

        domain = smb_neg_prot_domain(prot:prot);

        if(!domain){
                domain = string(get_kb_item("SMB/workgroup"));
        }
        if(!domain){
                domain = "";
        }
 }

 set_kb_item(name:"SMB/login", value:login);
 set_kb_item(name:"SMB/password", value:password);

 if(domain){
        set_kb_item(name:"SMB/domain", value:domain);
 }

 function remote_login(login, passwd, domain)
 {
 	login_defined = 0;

	soc = open_sock_tcp(port);
	if(!soc){
	        return(login_defined);
        }

  	r = smb_session_request(soc:soc, remote:name);
  	if(!r){
		close(soc);
	        return(login_defined);
	}

	prot = smb_neg_prot(soc:soc);
  	if(!prot){
                close(soc);
	        return(login_defined);
        }

  	r = smb_session_setup(soc:soc, login:login, password:password,
			      domain:domain, prot:prot);
  	if(!r){
                close(soc);
                return(login_defined);
        }

    	uid = session_extract_uid(reply:r);
    	r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
 	close(soc);

    	if(r){
		tid = tconx_extract_tid(reply:r);
		login_defined = 1;
	}
    	else{
		login_defined = 0;
 	}
	return(login_defined);
 }

 login_defined = remote_login(login:login, passwd:password, domain:domain);

 if(login_defined == 1)
 {
        report = string("It was possible to log into the remote host using user defined\n",
                        "login/password combinations :\n");
        security_note(data:report, port:port);
 }

 else if((login_deffined == 0) && login)
 {
        report = string("It was not possible to log into the remote host using user defined\n",
                        "login/password combinations :\n");
        security_note(data:report, port:port);
 }
