#
# This script was written by Noam Rathaus
#
# Modified by Michael Meyer 2009-05-04
#
# See the Nessus Scripts License for details
#

 desc = "
Synopsis :

A Voice Over IP service is listening on the remote port.

Description :

The remote host is running SIP (Session Initiation Protocol), a protocol
used for Internet conferencing and telephony.

Make sure the use of this program is done in accordance with your corporate
security policy.


See also :

http://www.cs.columbia.edu/sip/

Solution :

If this service is not needed, disable it or filter incoming traffic
to this port.

Risk factor : 

None";

if(description)
{
 script_id(11963);
 script_version("$Revision: 4336 $");
 name = "Detect SIP Compatible Hosts";
 script_name(name);


 script_description(desc);

 summary = "SIP Detection";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("This script is Copyright (C) 2003 Noam Rathaus");
 script_family("Service detection");
 script_require_ports(5060);
 exit(0);
}

include("dump.inc");
include("global_settings.inc");
include("misc_func.inc");
debug = debug_level;

if(islocalhost())exit(0);

myaddr = this_host();
dstaddr = get_host_ip();
returnport = rand() % 65535;

if (debug)
{
 display("returnport: ", returnport, "\n");
}

mystring = string("OPTIONS sip:", get_host_name(), " SIP/2.0\r\nVia: SIP/2.0/UDP ", myaddr, ":", returnport, "\r\nFrom: Test <sip:", myaddr, ":", returnport, ">\r\nTo: <sip:", myaddr, ":", returnport, ">\r\nCall-ID: 12312312@", myaddr, "\r\nCSeq: 1 OPTIONS\r\nMax-Forwards: 70\r\n\r\n");

if (debug)
{
 display("mystring: ", mystring, "\n");
}

len = strlen(mystring);

ippkt = forge_ip_packet(ip_hl   :5,
                        ip_v    :4,
                        ip_tos  :0,
                        ip_len  :20,
                        ip_id   :31337,
                        ip_off  :0,
                        ip_ttl  :64,
                        ip_p    :IPPROTO_UDP,
                        ip_src  :myaddr);

udppacket = forge_udp_packet(ip      :ippkt,
                             uh_sport:returnport,
                             uh_dport:5060,
                             uh_ulen :8 + len,
                             data    :mystring);

filter = string("udp and src " , dstaddr , " and dst port ", returnport);
rpkt = send_packet(udppacket, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
if(rpkt)
{
 if (debug)
 {
  display("return packet\n");
 }

 data = get_udp_element(udp:rpkt, element:"data");

 if (debug)
 {
  display("data: ", data, "\n");
}

 if ("SIP/2.0" >< data)
 {
  if (egrep(pattern: '^Server:', string: data))
  {
   banner = egrep(pattern: '^Server:', string: data);
   banner -= "Server: ";
   banner -= string("\r\n");
  } 
  
  else if (egrep(pattern: '^User-Agent:', string: data)) {
   
    banner = egrep(pattern: '^User-Agent:', string: data);
    banner -= "User-Agent: ";
    banner -= string("\r\n");

  }  

  if( banner ) { 
   if(!get_kb_item("sip/banner/5060"))
   {
    set_kb_item(name:"sip/banner/5060", value:banner);
   }
  }

  desc += '\n\nPlugin output :\n\n' + banner + '\n';

  if(egrep(pattern:"Allow:.*OPTIONS.*", string: data)) {

    OPTIONS = egrep(pattern:"Allow:.*OPTIONS.*", string: data);
    OPTIONS -= "Allow: ";
    OPTIONS = chomp(OPTIONS);
  }  

  if(!isnull(OPTIONS)) {

    desc += '\nSupported Options:\n' + OPTIONS + '\n';

  }  

  security_note(port:5060, protocol:"udp", data:desc);
  register_service(port: 5060, ipproto: "udp", proto: "sip");
 }
}

