#
# This script was written by Xue Yong Zhi <xueyong@udel.edu>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11347);
 script_bugtraq_id(717);
 script_version ("$Revision: 4336 $");
 script_cve_id("CVE-1999-0131");

 name = "Sendmail Local Starvation and Overflow";
 script_name(name);

 desc = "
The remote sendmail server, according to its version number,
has buffer overflow and denial of service problem through 
GECOS field, it gives root access to local users.

Solution : Install sendmail newer than 8.8.3 or install a vendor
supplied patch.

Risk factor : High (Local) / None (remote with no account)";

 script_description(desc);


 summary = "Checks the version number";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("This script is Copyright (C) 2003 Xue Yong Zhi");

 family = "SMTP problems";
 script_family(family);
 script_dependencie("find_service.nes", "smtpserver_detect.nasl");
 script_require_ports("Services/smtp", 25);
 script_require_keys("SMTP/sendmail");
 exit(0);
}

#
# The script code starts here
#

include("smtp_func.inc");

port = get_kb_item("Services/smtp");
if(!port) port = 25;

banner = get_smtp_banner(port:port);

if(banner)
{
 #looking for Sendmail 8.6.*, 8.7, 8.7.1-8.7.5
 if(egrep(pattern:".*sendmail[^0-9]*(SMI-)?8\.(6|6\.[0-9]+|7|7\.[1-5])/.*", string:banner, icase:TRUE))
 	security_hole(port);
}
