#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Kyuzo <ogl@SirDrinkalot.rm-f.net>
#
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(15822);
 script_cve_id("CVE-2002-1059");
 script_bugtraq_id(5287);
 script_xref(name:"OSVDB", value:"4991");
 
 script_version("$Revision: 4336 $");
  
 name = "SecureCRT SSH1 protocol version string overflow";

 script_name(name);
 
 desc = "
The remote host is using a vulnerable version of SecureCRT, a
SSH/Telnet client built for Microsoft Windows operation systems.

It has been reported that SecureCRT contain a remote buffer overflow
allowing an SSH server to execute arbitrary command via a specially
long SSH1 protocol version string.

Solution : Upgrade to SecureCRT 3.2.2, 3.3.4, 3.4.6, 4.1 or newer
Risk factor : High";


 script_description(desc);
 
 summary = "Determines the version of SecureCRT";

 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 family = "Windows";
 script_family(family);
 
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/Registry/Enumerated");

 script_require_ports(139, 445);
 exit(0);
}

version = get_kb_item("SMB/Registry/HKLM/SOFTWARE/VanDyke/SecureCRT/License/Version");
if ( ! version ) version = get_kb_item("SMB/Registry/HKLM/SOFTWARE/VanDyke/SecureCRT/Evaluation License/Version");
if ( ! version ) exit(0);

if (egrep(pattern:"(2\.|3\.([01]|2[^.]|2\.1[^0-9]|3[^.]|3\.[1-3][^0-9]|4[^.]|4\.[1-5][^0-9])|4\.0 beta [12])", string:version))
  security_hole(port);
