###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_zabbix_serv_arbitrary_cmd_exec_vuln.nasl 6535 2010-01-27 19:50:56Z jan $
#
# Zabbix Arbitrary Command Execution Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900226);
  script_version("$Revision: 6582 $: 1.0");
  script_cve_id("CVE-2009-4498");
  script_name("Zabbix Arbitrary Command Execution Vulnerability");
  desc = "
  Overview:
  This host is installed with Zabbix Server and is prone to arbitrary command
  execution vulnerability.

  Vulnerability Insight:
  This issue is caused due to an error in the 'node_process_command()'
  function, which can be exploited to execute arbitrary commands via
  specially crafted data.

  Impact:
  Successful exploitation will let the attackers to execute arbitrary commands
  via specially crafted data.

  Impact level: Application

  Affected Software/OS:
  Zabbix Server versions prior to 1.8

  Fix: Update to version 1.8 or above,
  http://www.zabbix.com/download.php

  References:
  http://secunia.com/advisories/37740/3/
  https://support.zabbix.com/browse/ZBX-1030
  http://www.vupen.com/english/advisories/2009/3514

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Zabbix");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Web application abuses");
  script_dependencies("zabbix_detect.nasl","zabbix_web_detect.nasl");
  script_require_ports("Services/www","Services/zabbix_server", 80,10051);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

## Get http ports
port = get_http_port(default:80);
if(!get_port_state(port)){
  exit(0);
}

## Check it can host PHP or not
if (!can_host_php(port:port)){
  exit(0);
}

## Get the Zabbix Version from the KB
if(!version = get_kb_item(string("www/", port, "/zabbix_client"))){
  exit(0);
}

## Extract the version
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$")){
  exit(0);
}
vers = matches[1];
if(!isnull(vers) && vers >!< "unknown")
{
  if(version_is_less(version: vers, test_version: "1.8")){
    ## Get the Zabbix Server port
    if(zabbix_port = get_kb_item("Services/zabbix_server")){
      port = zabbix_port;
    }
    security_warning(port:port);
    exit(0);
  }
}
