###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wow_raid_manager_detect.nasl 1040 2009-01-28 13:52:24Z feb $
#
# WOW Raid Manager Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900514);
  script_version("Revision: 1.0 ");
  script_name("WOW Raid Manager Version Detection");
  desc = "
  Overview: This script detects the installed version of WOW Raid Manager and
  sets the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of WOW Raid Manager");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach dir (make_list("/wrm", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if("WoW Raid Manager" >< rcvRes)
  {
    version = eregmatch(pattern:"WoW Raid Manager.* v([0-9.]+)", string:rcvRes);
    if(version[1] != NULL)
    {
      set_kb_item(name:"WoWRaidManager/Ver", value: version[1]);
      exit(0);
    }
  }
}
