###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wordpress_wptrackback_dos_vuln.nasl 5477 2009-10-27 17:21:38Z oct $
#
# WordPress wp-trackback.php Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900968);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3622");
  script_name("WordPress wp-trackback.php Denial of Service Vulnerability");
  desc = "
  Overview: The host is running WordPress and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  An error occurs in wp-trackbacks.php due to improper validation of user
  supplied data passed into 'mb_convert_encoding()' function. This can be
  exploited by sending multiple-source character encodings into the fuction.

  Impact:
  Successful exploitation will let the attacker to cause a Denial of Service
  due to high CPU consumption.

  Impact Level: System/Application

  Affected Software/OS:
  WordPress version prior to 2.8.5 on all platforms.

  Fix: Upgrade to WordPress version 2.8.5 or later.
  http://wordpress.org/download/

  References:
  http://secunia.com/advisories/37088/
  http://www.milw0rm.com/exploits/9431
  http://xforce.iss.net/xforce/xfdb/53884
  http://www.vupen.com/english/advisories/2009/2986

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of WordPress");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_wordpress_detect_900182.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

wpPort = get_http_port(default:80);
if(!wpPort){
  exit(0);
}

wpVer = get_kb_item("www/" + wpPort + "/WordPress");
wpVer = eregmatch(pattern:"^(.+) under (/.*)$", string:wpVer);

if(wpVer[1] != NULL)
{
  if(version_is_less(version:wpVer[1], test_version:"2.8.5")){
    security_warning(wpPort);
  }
}
