###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wordpress_mult_vuln_nov09.nasl 5795 2009-11-19 13:16:09Z nov $
#
# WordPress Multiple Vulnerabilities - Nov09
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900975);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3890", "CVE-2009-3891");
  script_bugtraq_id(37014, 37005);
  script_name("WordPress Multiple Vulnerabilities - Nov09");
  desc = "
  Overview:
  The host is running WordPress and is prone to multiple vulnerabilities.

  Vulnerability Insight:
  - The 'wp_check_filetype()' function in /wp-includes/functions.php does not
    properly validate files before uploading them.
  - Input passed into the 's' parameter in press-this.php is not sanitised
    before being displayed to the user.

  Impact:
  Attackers can exploit this issue to execute arbitrary PHP code by uploading
  malicious PHP files and to inject arbitrary web script or HTML code which
  will be executed in a user's browser session

  Impact Level: System/Application

  Affected Software/OS:
  WordPress version prior to 2.8.6 on all running platform.

  Fix: Update to Version 2.8.6
  http://wordpress.org/download/

  References:
  http://secunia.com/advisories/37332
  http://www.openwall.com/lists/oss-security/2009/11/15/2

  CVSS Score:
    CVSS Base Score     : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 4.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of WordPress");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_wordpress_detect_900182.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

# Get for WordPress Default Port
wpPort = get_http_port(default:80);
if(!wpPort){
  exit(0);
}

# Get KB for WordPress Version
wpVer = get_kb_item("www/" + wpPort + "/WordPress");
wpVer = eregmatch(pattern:"^(.+) under (/.*)$", string:wpVer);

if(wpVer[1] != NULL)
{
  # Check for WordPress Version prir to 2.8.6
  if(version_is_less(version:wpVer[1], test_version:"2.8.6")){
    security_warning(wpPort);
  }
}
