###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wireshark_mult_dos_vuln_lin.nasl 4887 2009-09-23 15:09:24Z sep $
#
# Wireshark Multiple Denial of Service Vulnerabilities (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901033);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3242");
  script_bugtraq_id(36408);
  script_name("Wireshark Multiple Denial of Service Vulnerabilities (Linux)");
  desc = "
  Overview: This host is installed with Wireshark and is prone to multiple
  Denial of Service vulnerabilities.

  Vulnerability Insight:
  An unspecified error in 'packet.c' in the GSM A RR dissector caused via
  unknown vectors related to 'an uninitialized dissector handle,' which
  triggers an assertion failure.

  Impact:
  Successful exploitation could result in Denial of Serivce condition.

  Impact Level: Application

  Affected Software/OS:
  Wireshark version 1.2.0 to 1.2.1 on Windows

  Fix: Upgrade to Wireshark 1.2.2
  http://www.wireshark.org/download.html

  References:
  http://secunia.com/advisories/36754
  http://www.wireshark.org/security/wnpa-sec-2009-06.html
  https://bugs.wireshark.org/bugzilla/show_bug.cgi?id=3893

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_lin.nasl");
  script_require_keys("Wireshark/Linux/Ver");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Linux/Ver");
if(!sharkVer){
  exit(0);
}

# Grep for Wireshark version 1.2.0 to 1.2.1
if(version_in_range(version:sharkVer, test_version:"1.2.0", test_version2:"1.2.1")){
  security_warning(0);
}
