##############################################################################
#
#  WinGate IMAP Server Buffer Overflow Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/18
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0116
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900201);
 script_bugtraq_id(30606);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("WinGate IMAP Server Buffer Overflow Vulnerability");
 script_summary("Check for the version of WinGate");
 desc = "
 Overview : This host is running Qbik WinGate, which is prone to Denial of
 Service Vulnerability.

 Vulnerability Insight :
        The vulnerability is caused due to a boundary error in the processing 
        of IMAP commands. This can be exploited by issuing an IMAP LIST command
        with an overly long argument.

        Impact : Exploiting this issue will consume computer resources and deny 
        access to legitimate users or to potentially compromise a vulnerable
        system or may allow execution of arbitrary code. 

 Impact Level : Application

 Affected Software/OS :
        WinGate 6.2.2 and prior versions on Windows (All).

 Fix : No solution/patch is available as on 14th August, 2008. Information
 regarding this issue will update once the solution details are available.
 For updates refer, http://www.wingate.com/download/wingate/download.php

 References : http://secunia.com/advisories/31442/
 http://www.securityfocus.com/archive/1/495264

 CVSS Score :
        CVSS Base Score     : 6.3 (AV:N/AC:M/Au:N/Au:SI/C:N/I:N/A:C)
        CVSS Temporal Score : 5.7
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("imap_func.inc");

 winPort = get_kb_item("Services/imap");
 if(!winPort){
        winPort = 143;
 }

 if(!get_port_state(winPort)){
        exit(0);
 }

 if("WinGate" >!< get_imap_banner(port:winPort)){
        exit(0);
 }

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();

 if(!port) port = 139;

 if(!get_port_state(port))exit(0);

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
        close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe)
 {
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
        close(soc);
        exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe,
                          key:key, reply:handle);
 if(!key_h)
 {
 	exit(0);
 }
 
 enumKeys = registry_enum_key(soc:soc, uid:uid, tid:tid,
                              pipe:pipe, reply:key_h);

 foreach entry (enumKeys)
 {
 	if("WinGate" >< entry)
	{
		winGateName = registry_get_sz(item:"DisplayName",
                                              key:key + entry);
                if(winGateName)
		{
			if(egrep(pattern:"WinGate 6\.[01](\..*)?|6\.2(\.[0-2])?$",
					  string:winGateName)) {
				security_warning(winPort);
			}
		}
 		exit(0);
	}
 }
