###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_vuplayer_detect.nasl 872 2009-01-22 12:19:24Z jan $
#
# VUPlayer Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900191);
  script_version("Revision: 1.0 ");
  script_name("VUPlayer Version Detection");
  desc = "
  Overview: This script detect the installed version of VUPlayer and set the
  result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the KB for the version of VUPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\VUPlayer";
vuplayerName = registry_get_sz(key:key, item:"DisplayName");
if(!vuplayerName){
  key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Player";
  vuplayerName = registry_get_sz(key:key, item:"DisplayName");
}

if(vuplayerName =~ "^(VUPlayer|Player)")
{
  exePath = registry_get_sz(key:key, item:"UninstallString");
  if(!exePath){
    exit(0);
  }

  exePath = ereg_replace(pattern:'"', replace:"", string:exePath);
  exePath = exePath - "Uninstall.exe" + vuplayerName + ".exe";

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

  vuplayerVer = GetVer(file:file, share:share);
  if(vuplayerVer != NULL){
    set_kb_item(name:"VUPlayer/Version", value:vuplayerVer);
  }
}
