###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_vmware_prdts_mult_vuln_win_sep09.nasl 4626 2009-09-15 13:20:21Z sep $
#
# VMware Products Multiple Vulnerabilities (Win) sep09
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901020);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0199", "CVE-2009-2628");
  script_bugtraq_id(36290);
  script_name("VMware Products Multiple Vulnerabilities (Win) sep09");
  desc = "
  Overview : The host is installed with VMWare products and are prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  The multiple flaws are due to,
  - An heap overflow error in the VMnc codec (vmnc.dll) when processing a video
    file with mismatched dimension.
  - An heap corruption error in the VMnc codec (vmnc.dll) when processing a video
    with a height of less than 8 pixels.

  Impact:
  Successful exploitation will let the attacker to cause a heap-based buffer
  overflow via a specially crafted video file with mismatched dimensions.

  Impact Level: System/Application

  Affected Software/OS:
  VMware Workstation versions prior to 6.5.3 Build 185404
  VMware Player versions prior to 2.5.3 build 185404

  Fix : Upgrade your VMWares according to the below link.
  http://lists.vmware.com/pipermail/security-announce/2009/000065.html

  References:
  http://www.kb.cert.org/vuls/id/444513
  http://secunia.com/secunia_research/2009-25/
  http://www.vupen.com/english/advisories/2009/2553
  http://www.vmware.com/security/advisories/VMSA-2009-0012.html

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of VMware Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("gb_vmware_prdts_detect_win.nasl");
  script_require_keys("VMware/Win/Installed");
  exit(0);
}


include("version_func.inc");

if(!get_kb_item("VMware/Win/Installed"))
{
  exit(0);
}

# Check for VMware Player
vmplayerVer = get_kb_item("VMware/Player/Win/Ver");
if(vmplayerVer != NULL )
{
  if(version_is_less(version:vmplayerVer, test_version:"2.5.3"))
  {
    security_hole(0);
    exit(0);
  }
}

#Check for VMware Workstation
vmworkstnVer = get_kb_item("VMware/Workstation/Win/Ver");
if(vmworkstnVer != NULL)
{
  if(version_is_less(version:vmworkstnVer, test_version:"6.5.3")){
    security_hole(0);
  }
}
