###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_vicidial_mult_sql_inj_vuln.nasl 3169 2009-08-24 15:06:33Z aug $
#
# VICIDIAL Call Center Suite Multiple SQL Injection Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900916);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2234");
  script_bugtraq_id(35056);
  script_name("VICIDIAL Call Center Suite Multiple SQL Injection Vulnerabilities");
  desc = "

  Overview: This host is installed with VICIDIAL Call Center Suite and is
  prone to multiple SQL Injection vulnerabilities.

  Vulnerability Insight:
  This flaw occurs due to lack of sanitation of user supplied data passed into
  the admin.php and can be exploited via username and password parameters.

  Impact:
  Attackers can exploit this issue via specially crafted SQL statements to
  access and modify the back-end database.

  Impact Level: Application

  Affected Software/OS:
  VICIDIAL Call Center Suite 2.0.5 through 2.0.5-173

  Fix: Apply the available patch.
  http://www.eflo.net/vicidial/security_fix_admin_20090522.patch

  *****
  NOTE: Ignore this warning if the above mentioned patch is already applied.
  *****

  References:
  http://www.milw0rm.com/exploits/8755
  http://xforce.iss.net/xforce/xfdb/50665
  http://www.eflo.net/VICIDIALforum/viewtopic.php?t=8075

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of VICIDIAL Call Center Suite");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

viciPort = get_http_port(default:80);
if(!viciPort){
  viciPort = 80;
}

if(!get_port_state(viciPort)){
  exit(0);
}

foreach dir (make_list("/", "/www/agc", "/agc", "/vicidial", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/vicidial.php"), port:viciPort);
  rcvRes = http_send_recv(port:viciPort, data:sndReq);

  if((rcvRes != NULL) && ("VICIDIAL web client" >< rcvRes))
  {
    viciVer = eregmatch(pattern:"VERSION: (([0-9.]+)-?([0-9]+)?)", string:rcvRes);
    viciVer[1] = ereg_replace(pattern:"-", replace:".", string:viciVer[1]);

    if(viciVer[1] != NULL)
    {
      if(version_is_less_equal(version:viciVer[1], test_version:"2.0.5.206"))
      {
        security_hole(viciPort);
        exit(0);
      }
    }
  }
}
