###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tvp_bof_vuln.nasl 896 2009-01-28 20:15:29Z jan $
#
# Total Video Player Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900454);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0261");
  script_bugtraq_id(33373);
  script_name("Total Video Player Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with Total Video Player and is prone to
  Buffer Overflow vulnerability.

  Vulnerability Insight:
  This flaw is due to improper boundary check at 'DefaultSkin.ini' in the
  ColumnHeaderSpan value which copies data to an insufficiently sized memory
  buffer.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the application and can cause stack overflow to make the resource
  unavailable.

  Impact Level: Application

  Affected Software/OS:
  Total Video Player version 1.31 and prior on Windows.

  Fix: No solution or patch is available as on 30th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.effectmatrix.com/total-video-player/index.htm

  References:
  http://www.milw0rm.com/exploits/7839

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Total Video Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_tvp_detect.nasl");
  script_require_keys("TotalVideo/Player/Ver");
  exit(0);
}


include("version_func.inc");

tvpVer = get_kb_item("TotalVideo/Player/Ver");
if(!tvpVer){
  exit(0);
}

# Check for Total Video Player version 1.31 and prior
if(version_is_less_equal(version:tvpVer, test_version:"1.31")){
  security_hole(0);
}
