#############################################################################
#
#  Trend Micro Web Management Authentication Bypass Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/25
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0138
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900205);
 script_bugtraq_id(30792);
 script_cve_id("CVE-2008-2433");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Privilege escalation");
 script_name("Trend Micro Web Management Authentication Bypass Vulnerability");
 script_summary("Check for the version of Trend Micro OfficeScan");
 desc = "
 Overview : This Remote host is installed with Trend Micro OfficeScan, which
 is prone to Authentication Bypass Vulnerability.

 Vulnerability Insight :

        The flaw is caused due to insufficient entropy in a random session
        token used to identify an authenticated manager using the web console.

        Impact : Remote users can gain administrative access on the target
        application and allow arbitrary code execution.

 Impact Level : Application.

 Affected Software/OS : 
        Trend Micro Client Server Messaging Security (CSM) versions 3.5 and 3.6
        Trend Micro OfficeScan Corporate Edition versions 7.0 and 7.3
        Trend Micro OfficeScan Corporate Edition version 8.0
        Trend Micro Worry-Free Business Security (WFBS) version 5.0

 Fix : Partially Fixed.

 Fix is available for Trend Micro OfficeScan 8.0 and Worry-Free Business Security 5.0.
 http://www.trendmicro.com/ftp/products/patches/OSCE_8.0_SP1_Win_EN_CriticalPatch_B2402.exe
 http://www.trendmicro.com/ftp/products/patches/OSCE_8.0_Win_EN_CriticalPatch_B1351.exe 
 http://www.trendmicro.com/ftp/products/patches/OSCE_8.0_SP1_Patch1_Win_EN_CriticalPatch_B3037.exe
 http://www.trendmicro.com/ftp/products/patches/WFBS_50_WIN_EN_CriticalPatch_B1404.exe

 *****
 NOTE : Ignore this warning if above mentioned patch is applied already.
 *****

 References : http://secunia.com/advisories/31373/
 http://securitytracker.com/alerts/2008/Aug/1020732.html

 CVSS Score :
        CVSS Base Score	    : 8.3 (AV:N/AC:M/Au:NR/C:C/I:P/A:P)
        CVSS Temporal Score : 6.4
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}

 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 scanVer = registry_get_sz(key:"SOFTWARE\TrendMicro\OfficeScan\service" + 
                               "\Information", item:"Server_Version");
 if(!scanVer){
	exit(0);
 }

 if(egrep(pattern:"^([0-7]\..*|8\.0)$", string:scanVer)){
	security_warning(0);
 }
