###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_torrentvolve_xss_vuln.nasl 3007 2009-06-25 11:46:24Z jun $
#
# TorrentVolve archive.php XSS Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900577);
  script_version("Revision: 1.0");
  script_cve_id("CVE-2009-2101");
  script_name("TorrentVolve archive.php XSS Vulnerability");
  desc = "

  Overview: This host is running TorrentVolve and is prone to Cross Site
  Scripting vulnerability.

  Vulnerability Insight:
  The flaw occurs because archive.php does not sanitise the data passed into
  'deleteTorrent' parameter before being returned to the user.

  Impact:
  Successful exploitation will let the attacker to delete arbitrary files
  on the affected system if register_globals is enabled.

  Impact level: Application

  Affected Software/OS:
  TorrentVolve 1.4 and prior.

  Fix: No solution or patch is available as on 25th June, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/torrentvolve/

  References:
  http://www.milw0rm.com/exploits/8931
  http://xforce.iss.net/xforce/xfdb/51088

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for version of TorrentVolve");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_torrentvolve_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

tvPort = get_http_port(default:80);
if(!tvPort){
  exit(0);
}

tvVer = get_kb_item("www/" + tvPort + "/TorrentVolve");
tvVer = eregmatch(pattern:"^(.+) under (/.*)$", string:tvVer);
if(tvVer[1] == NULL){
  exit(0);
}

if(version_is_less_equal(version:tvVer[1], test_version:"1.4")){
  security_hole(tvPort);
}
