###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tor_replay_attack_vuln_win.nasl 1062 2009-02-26 12:07:29Z feb $
#
# Tor Replay Attack Vulnerability (Windows)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900322);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0654");
  script_name("Tor Replay Attack Vulnerability (Windows)");
  desc = "

  Overview: This host is installed with Tor Anonimity Proxy and is prone
  to replay attack vulnerability.

  Vulnerability Insight:
  Flaw is in the data flow at the end of the circuit which lets the attacker
  to modify the relayed data.

  Impact:
  Successful exploitation will let the remote attacker cause replay attacks
  in the network and can compromise router functionalities.

  Impact level: Network

  Affected Software/OS:
  Tor version 0.2.0.34 and prior on Windows.

  Fix: No solution or patch is available as on 03rd March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, https://www.torproject.org

  References:
  http://blog.torproject.org/blog/one-cell-enough
  http://www.blackhat.com/presentations/bh-dc-09/Fu/BlackHat-DC-09-Fu-Break-Tors-Anonymity.pdf

  CVSS Score:
    CVSS Base Score     : 5.1 (AV:N/AC:H/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 4.3
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Tor Proxy");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_tor_detect_win.nasl");
  script_require_keys("Tor/Win/Ver");
  exit(0);
}


include("version_func.inc");

torVer = get_kb_item("Tor/Win/Ver");
if(torVer != NULL)
{
  # Grep for version 0.2.0.34 and prior
  if(version_is_less_equal(version:torVer, test_version:"0.2.0.34")){
    security_warning(0);
  }
}
