###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tnftpd_csrf_vuln.nasl 4208 2009-08-24 15:13:23Z aug $
#
# tnftpd 'ftp://' Cross-Site Request Forgery Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901006);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7016");
  script_name("tnftpd 'ftp://' Cross-Site Request Forgery Vulnerability");
  desc = "
  Overview: The host is running tnftpd server and is prone to Cross-Site Request
  Forgery vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the application truncating an overly long FTP
  command and improperly interpreting the remainder string as a new FTP
  command. This can be exploited via unknown vectors, probably involving a
  crafted 'ftp://' link to a tnftpd server.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code to
  perform CSRF attacks, Web cache poisoning, and other malicious activities.

  Impact Level: Application/Network

  Affected Software/OS:
  NetBSD, tnftpd Version prior to 20080929

  Fix: Upgrade to tnftpd version 20080929 or later,
  ftp://ftp.netbsd.org/pub/NetBSD/misc/tnftp/

  References:
  http://secunia.com/advisories/31958
  http://xforce.iss.net/xforce/xfdb/45534
  http://freshmeat.net/projects/tnftpd/?branch_id=14355&release_id=285654

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of tnftpd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("FTP");
  script_dependencies("secpod_tnftpd_detect.nasl");
  script_require_keys("tnftpd/ver");
  exit(0);
}


include("version_func.inc");

tnftpVer = get_kb_item("/tnftpd/Ver");

if(tnftpVer != NULL)
{
  if(version_is_less(version:tnftpVer, test_version:"20080929")){
    security_warning(21);
  }
}
