###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_thunderbird_mult_vuln_dec09_win.nasl 6283 2009-12-18 18:45:33Z dec $
#
# Thunderbird Multiple Vulnerabilities Dec-09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902004);
  script_version("$Revision: 6243 $: 1.0");
  script_cve_id("CVE-2009-3979", "CVE-2009-3980", "CVE-2009-3981", "CVE-2009-3982");
  script_bugtraq_id(37361, 37362, 37363, 37364);
  script_name("Thunderbird Multiple Vulnerabilities Dec-09 (Win)");
  desc = "
  Overview: The host is installed with Thunderbird and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  Memory corruption error due to multiple unspecified flaws in the browser
  engine, which can be exploited via unknown vectors.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code via
  unknown vectors or compromise a user's system.

  Impact Level: Application/System

  Affected Software/OS:
  Thunderbird version 3.0 and prior on Windows.

  Fix:
  No solution or patch is available as on 21st December, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozillamessaging.com/en-US/thunderbird/

  References:
  http://secunia.com/advisories/37699
  http://www.vupen.com/english/advisories/2009/3547
  http://www.mozilla.org/security/announce/2009/mfsa2009-65.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_thunderbird_detect_win.nasl");
  script_require_keys("Thunderbird/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Thunderbird Check
tbVer = get_kb_item("Thunderbird/Win/Ver");
if(tbVer)
{
  # Grep for Thunderbird version 3.0 and prior
  if(version_is_less_equal(version:tbVer, test_version:"3.0")){
    security_hole(0);
  }
}
