###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_thunderbird_mem_crptn_vuln_jul09_lin.nasl 3622 2009-07-23 16:25:33Z jul $
#
# Mozilla Thunderbird Memory Corruption Vulnerabilities July-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900802);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2462", "CVE-2009-2463", "CVE-2009-2464",
                "CVE-2009-2465", "CVE-2009-2466");
  script_bugtraq_id(35765, 35769, 35775, 35770, 35776);
  script_name("Mozilla Thunderbird Memory Corruption Vulnerabilities July-09 (Linux)");
  desc = "

  Overview: The host is installed with Thunderbird and is prone to Remote Code
  Execution vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to error in browser engine which can be exlpoited
  via some of the known vectors and unspecified vectors.

  Impact:
  Successful exploitation could allow remote attacker to execute arbitrary code,
  memory corruption, and results in Denial of Service condition.

  Impact Level:System/Application

  Affected Software/OS:
  Mozilla Thunderbird version 2.0.0.22 and prior on Linux.

  Fix: No solution or patch is available as on 23rd, July 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.com/

  References:
  http://secunia.com/advisories/35914
  http://www.vupen.com/english/advisories/2009/1972
  http://www.mozilla.org/security/announce/2009/mfsa2009-34.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_thunderbird_detect_lin.nasl");
  script_require_keys("Thunderbird/Linux/Ver");
  exit(0);
}


include("version_func.inc");

tbVer = get_kb_item("Thunderbird/Linux/Ver");
if(!tbVer){
  exit(0);
}

# Grep for Thunderbird version <= 2.0.0.22
if(version_is_less_equal(version:tbVer, test_version:"2.0.0.22")){
  security_hole(0);
}
