###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_symantec_epoint_prtn_sec_bypass_vuln.nasl 7359 2010-02-24 14:47:50Z feb $
#
# Symantec Endpoint Protection Scan Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902124);
  script_version("$Revision: 6841 $: 1.0");
  script_cve_id("CVE-2010-0106");
  script_bugtraq_id(38219);
  script_name("Symantec Endpoint Protection Scan Bypass Vulnerability");
  desc = "
  Overview: The host is installed with Symantec Endpoint Protection and is
  possible to bypass security scan.

  Vulnerability Insight:
  Issue is caused by an unspecified error in the 'on-demand' scanning feature
  when another entity denies read access to the AntiVirus while the Tamper
  protection is disabled.

  Impact:
  Successful exploitation will let attacker to pass sufficient specific events
  to the application to bypass an on-demand scan.

  Impact level: Application/System

  Affected Software/OS:
  Symantec Endpoint Protection 11.x

  Fix: No solution or patch is available as on 24th February, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.symantec.com/downloads/index.jsp

  Workaround:
  - Enable Tamper Protection.

  References:
  http://secunia.com/advisories/38653
  http://www.vupen.com/english/advisories/2010/0410
  http://www.symantec.com/business/security_response/securityupdates/detail.jsp?fid=security_advisory&pvid=security_advisory&year=2010&suid=20100217_00

  CVSS Score:
    CVSS Base Score      : 1.9 (AV:L/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 1.5
  Risk factor: Informatinal";

  script_description(desc);
  script_summary("Check for the version of Symantec Endpoint Protection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("General");
  script_dependencies("secpod_symantec_prdts_detect.nasl");
  script_require_keys("Symantec/Endpoint/Protection");
  exit(0);
}


include("version_func.inc");

sepVer = get_kb_item("Symantec/Endpoint/Protection");
if(!isnull(sepVer) && (sepVer=~ "^11.*")){
  security_warning(0);
}
