###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sun_java_dir_server_info_disc_vuln_lin.nasl 1828 2009-04-29 18:21:29Z apr $
#
# Sun Java Directory Server Information Disclosure Vulnerability (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900706);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1332");
  script_bugtraq_id(34548);
  script_name("Sun Java Directory Server Information Disclosure Vulnerability (Linux)");
  desc = "

  Overview:
  This host is running Sun Java Directory Server and is prone to Information
  Disclosure Vulnerability.

  Vulnerability Insight:
  This flaw is due to unspecified error which can be exploited to determine
  the existence of a file on a system and disclose a single line of the file's
  content.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the application and can gain sensitive information about the
  presence of folders and files.

  Impact level: Application

  Affected Software/OS:
  Sun Java System Directory Server 5.2
  Sun Java System Directory Server Enterprise 5.0

  Fix: Upgrade to Sun Java Directory Server Enterprise 6.0 or later
  http://www.sun.com/software/products/directory_srvr_ee/get.jsp

  References:
  http://secunia.com/advisories/34751
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-255848-1

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Java Directory Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_sun_java_dir_server_detect_lin.nasl");
  script_require_keys("Sun/JavaDirServer/Linux/Ver");
  exit(0);
}


include("version_func.inc");

appVer = get_kb_item("Sun/JavaDirServer/Linux/Ver");
if(!appVer){
  exit(0);
}

# Grep for Directory Server version 5.2 or 5.0
if(version_is_less_equal(version:appVer, test_version:"5.2")){
  security_warning(0);
}
