###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_squirrelmail_csrf_vuln.nasl 4303 2009-08-27 16:26:24Z aug $
#
# SquirrelMail Multiple Cross-Site Request Forgery Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900830);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2964");
  script_name("SquirrelMail Multiple Cross-Site Request Forgery Vulnerabilities");
  desc = "
  Overview: This host is running SquirrelMail and is prone to multiple Cross
  Site Request Forgery vulnerabilities.

  Vulnerability Insight:
  Multiple CSRF errors are caused via features such as send message and change
  preferences, related to addrbook_search_html.php, folders_rename_getname.php,
  folders_rename_do.php, folders_subscribe.php, move_messages.php, options.php,
  options_highlight.php, options_identities.php, options_order.php, search.php,
  addressbook.php, compose.php, folders.php, folders_create.php, vcard.php and
  folders_delete.php in /src and mailbox_display.php in functions directory.

  Impact:
  Attacker may leverage this issue to modify user preferences, delete emails,
  and potentially send emails, and can hijack the authentication of unspecified
  victims.

  Impact Level: System/Application

  Affected Software/OS:
  SquirrelMail version 1.4.19 and prior on Linux.

  Fix: Upgrade to version 1.4.20 RC1 or latest
  http://www.squirrelmail.org/download.php
  or
  Apply Patch from below link
  http://squirrelmail.svn.sourceforge.net/viewvc/squirrelmail?view=rev&revision=13818

  References:
  http://secunia.com/advisories/34627
  http://xforce.iss.net/xforce/xfdb/52406
  http://www.squirrelmail.org/security/issue/2009-08-12

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of SquirrelMail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("squirrelmail_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

squirrelPort = get_http_port(default:80);

if(isnull(squirrelPort))
{
  exit(0);
}

squirrelVer = get_kb_item("www/" + squirrelPort + "/squirrelmail");

if(isnull(squirrelVer))
{
  exit(0);
}

squirrelVer = eregmatch(pattern:"^(.+) under (/.*)$", string:squirrelVer);
squirrelVer[1] = ereg_replace(pattern:"-", replace:".", string:squirrelVer[1]);

if(!isnull(squirrelVer[1]))
{
  # Check for SquirrelMail version <= 1.4.19
  if(version_is_less_equal(version:squirrelVer[1], test_version:"1.4.19")){
    security_warning(squirrelPort);
  }
}
