###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sorinara_audio_player_bof_vuln.nasl 2344 2009-07-23 14:58:36Z jul $
#
# Sorinara Streaming Audio Player Stack Overflow Vulnerability
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Modified by: Nikita MR (rnikita@secpod.com)
# Date: 23rd July 2009
# Changes: Added CVE-2009-2568 and updated the  vulnerability insight.
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900649);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1644", "CVE-2009-2568");
  script_bugtraq_id(34861, 34842);
  script_name("Sorinara Streaming Audio Player Stack Overflow Vulnerability");
  desc = "

  Overview: This host is running Sorinara Streaming Audio Player and is prone
  to Stack Overflow Vulnerability.

  Vulnerability Insight:
  This vulnerability is caused due to improper boundary checks when processing
  playlist 'pla' and '.m3u' files.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in
  the context of the affected system and cause the application to crash by
  overflowing the stack memory location.

  Affected Software/OS:
  Sorinara Streaming Audio Player version 0.9 and prior

  Fix: No solution or patch is available as on 29th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.sorinara.com/sap/download.html

  References:
  http://www.milw0rm.com/exploits/8640
  http://www.milw0rm.com/exploits/8625
  http://xforce.iss.net/xforce/xfdb/50369
  http://www.milw0rm.com/exploits/8620
  http://www.milw0rm.com/exploits/8617
  http://xforce.iss.net/xforce/xfdb/50339

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for version of Sorinara Streaming Audio Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139,445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\SAP\";
vendName = registry_get_sz(key:key, item:"DisplayName");
if("SAP" >< vendName)
{
  readmePath = registry_get_sz(key:key, item:"UninstallString");
  if(!readmePath){
    exit(0);
  }

  readmePath = readmePath - "\uninstall.exe /uninstall";
  readmePath = readmePath + "\Help";

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:readmePath);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                       string:readmePath + "\index.htm");
  readmeText = read_file(share:share, file:file, offset:0, count:4500);
  if(!readmeText){
    exit(0);
  }

  sapVer = eregmatch(pattern:"SAP ([0-9.]+)", string:readmeText);
  if(sapVer[1] != NULL)
  {
    if(version_is_less_equal(version:sapVer[1], test_version:"0.9")){
      security_hole(0);
    }
  }
}
