###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_slurm_privilege_escalation_vuln.nasl 2975 2009-06-18 22:32:26Z jun $
#
# Privilege Escalation Vulnerability in SLURM
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900375);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2084");
  script_bugtraq_id(34638);
  script_name("Privilege Escalation Vulnerability in SLURM");
  desc = "

  Overview: This host has SLURM (Simple Linux Utility for Resource Management)
  installed and is prone to Privilege Escalation vulnerability.

  Vulnerability Insight:
  - Error within the sbcast implementation when establishing supplemental
    groups, which can be exploited to e.g. access files with the supplemental
    group privileges of the slurmd daemon.
  - Error in slurmctld daemon is not properly dropping supplemental groups
    when handling the 'strigger' command, which can be exploited to
    e.g. access files with the supplemental group privileges of the
    slurmctld daemon.

  Impact:
  This can be exploited by malicious SLURM local users to gain escalated
  privileges.

  Impact Level: Application/System

  Affected Software/OS:
  SLURM all versions of 1.2 and 1.3 prior to 1.3.15 on Linux (Debian)

  Fix: Upgrade to SLURM version 1.3.14 or later
  https://computing.llnl.gov/linux/slurm/download.html

  References:
  http://www.debian.org/security/2009/dsa-1776
  http://www.vupen.com/english/advisories/2009/1128
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=524980
  http://sourceforge.net/project/shownotes.php?release_id=676055&group_id=157944

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of SLURM");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Privilege escalation");
  script_dependencies("secpod_slurm_detect.nasl");
  script_require_keys("SLURM/Ver");
  exit(0);
}


include("version_func.inc");

# Check for SLURM all versions of 1.2 and 1.3 prior to 1.3.15
slurmVer = get_kb_item("SLURM/Ver");
if(slurmVer)
{
  if(version_in_range(version:slurmVer, test_version:"1.2", test_version2:"1.3.13")){
    security_hole(0);
  }
}
