###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ruby_detect_lin.nasl 2953 2009-06-16 12:51:12Z jun $
#
# Ruby Version Detection (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900569);
  script_version("$Revision: 1.0 $");
  script_name("Ruby Version Detection (Linux)");
  desc = "
  Overview: This script detects the version of Ruby and sets the
  reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Ruby");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

rubyName = find_bin(prog_name:"ruby", sock:sock);
foreach binaryName (rubyName)
{
  rubyVer = get_bin_version(full_prog_name:chomp(binaryName), version_argv:"--version",
                             ver_pattern:"ruby (.*)", sock:sock);
  if(rubyVer[1])
  {
    if("patchlevel" >< rubyVer[1])
    {
      rubyVer = eregmatch(pattern:"([0-9.]+).*patchlevel ([0-9]+)", string:rubyVer[1]);
      if(rubyVer[1] != NULL)
      {
        if(rubyVer[2] != NULL){
          rubyVer = rubyVer[1] + ".p" + rubyVer[2];
      }
      else
        rubyVer = rubyVer[1];
      }
    }
    else
    {
      rubyVer = eregmatch(pattern:"([0-9.]+)([a-z][0-9]+)?", string:rubyVer[1]);
      if(rubyVer[1] != NULL)
      {
        if(rubyVer[2] != NULL){
          rubyVer = rubyVer[1] + "." + rubyVer[2];
        }
        else
          rubyVer = rubyVer[1];
      }
    }
    set_kb_item(name:"Ruby/Lin/Ver", value:rubyVer);
    ssh_close_connection();
   exit(0);
  }
}
ssh_close_connection();
