###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_qemu_vnc_dos_vuln_lin.nasl 5475 2009-10-30 18:52:41Z oct $
#
# QEMU VNC Server Denial of Service Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900970);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3616");
  script_bugtraq_id(36716);
  script_name("QEMU VNC Server Denial of Service Vulnerability (Linux)");
  desc = "
  Overview: This host is running QEMU and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  Multiple use-after-free errors occur in 'vnc.c' in VNC server while processing
  malicious 'SetEncodings' messages sent via VNC client.

  Impact:
  Successful exploitation will let the attacker cause memory or CPU consumption,
  resulting in Denial of Service condition.

  Impact level: Application/System

  Affected Software/OS:
  QEMU version 0.10.6 and prior on Linux.

  Fix: Apply the available patches.
  http://git.savannah.gnu.org/cgit/qemu.git/commit/?id=753b405331
  http://git.savannah.gnu.org/cgit/qemu.git/commit/?id=198a0039c5

  *****
  NOTE: Ignore this warning if the above mentioned patches is already applied.
  *****

  References:
  https://bugzilla.redhat.com/show_bug.cgi?id=505641
  http://www.openwall.com/lists/oss-security/2009/10/16/8

  CVSS Score:
    CVSS Base Score     : 8.5 (AV:N/AC:M/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of QEMU");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_qemu_detect_lin.nasl");
  script_require_keys("QEMU/Lin/Ver");
  exit(0);
}


include("version_func.inc");

vncVer = get_kb_item("QEMU/Lin/Ver");
if(vncVer)
{
  # Grep for QEMU version <= 0.10.6
  if(version_is_less_equal(version:vncVer, test_version:"0.10.6")){
    security_hole(0);
  }
}
