##############################################################################
#
#  Python Multiple Vulnerabilities (Win) 
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/05
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0087
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900105);
 script_bugtraq_id(30491);
 script_cve_id("CVE-2008-2315", "CVE-2008-2316", "CVE-2008-3142", 
	       "CVE-2008-3143","CVE-2008-3144");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Buffer overflow");
 script_name("Python Multiple Vulnerabilities (Win)");
 script_summary("Check for vulnerable version of Pyhton");
 desc = "

 Overview : The host is installed with Python, which is prone to multiple 
 vulnerabilities.
        
 Vulnerability Insight :
 
        The flaws exists due to integer overflow in,
        - hashlib module, which can lead to an unreliable cryptographic digest
          results.
        - the processing of unicode strings.
        - the PyOS_vsnprintf() function on architectures that do not have a
          vsnprintf() function.
        - the PyOS_vsnprintf() function when passing zero-length strings can
          lead to memory corruption.
          
        Impact : Successful exploitation could potentially causes attackers to
        execute arbitrary code or create a denial of service condition. 
        
 Impact Level : Application
 
 Affected Software/OS :
        Python 2.5.2 and prior on Linux (All).
        
 Fix : Fix is available in the SVN repository,
 http://svn.python.org 
 
 References :
 http://bugs.python.org/issue2588
 http://bugs.python.org/issue2589
 http://bugs.python.org/issue2620
 
 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.0
 Risk factor : Medium";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!(get_kb_item("SMB/WindowsVersion"))){
        exit(0);
 }

 name = kb_smb_name();
 login = kb_smb_login();
 domain = kb_smb_domain();
 pass = kb_smb_password();
 port = kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
 if(!r)
 {
	close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");

 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
        close(soc);
        exit(0);
 }
 
 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe)
 {
 	close(soc);
	exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
        close(soc);
        exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
 pyKey = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
 if(!pyKey)
 {
	close(soc);
        exit(0);
 }

 entries = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:pyKey);
 close(soc);

 foreach entry (entries)
 {
        pyName = registry_get_sz(key:key + entry, item:"DisplayName");
        if("Python" >< pyName)
        {
          	if(egrep(pattern:"Python ([01]\..*|2\.([0-4]\..*|5\.[0-2]))$",
			 string:pyName)){
                	security_warning(0);
		}
                exit(0);
        }
 }
